/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.dbunit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;

public class DbUnitUtil {
    private static final Log LOG = LogFactory.getLog(DbUnitUtil.class);

    private DbUnitUtil() {
    }

    public static IDatabaseConnection getConnection(Properties settings) throws SQLException, DatabaseUnitException {
        String driverClass = settings.getProperty("driverClass");
        if (driverClass != null) {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Failed to load the driver class.", (Throwable)e);
            }
        }
        return DbUnitUtil.getConnection(settings.getProperty("url"), settings.getProperty("user"), settings.getProperty("password"));
    }

    public static IDatabaseConnection getConnection(String url, String user, String password) throws SQLException, DatabaseUnitException {
        Connection jdbcConnection = DriverManager.getConnection(url, user, password);
        return new DatabaseConnection(jdbcConnection);
    }
}

