/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ColumnValues
implements Iterable<Column>,
Cloneable {
    List<Column> columns = new ArrayList<Column>();

    public ColumnValues() {
    }

    public ColumnValues(Object pk) {
        this.columns.add(new Column(null, pk));
    }

    public ColumnValues(Object ... pks) {
        for (Object pk : pks) {
            this.columns.add(new Column(null, pk));
        }
    }

    public ColumnValues(Column ... columns) {
        this.columns.addAll(Arrays.asList(columns));
    }

    public ColumnValues(Map<String, Object> pks) {
        for (Map.Entry<String, Object> entry : pks.entrySet()) {
            this.columns.add(new Column(entry.getKey(), entry.getValue()));
        }
    }

    public static Set<ColumnValues> setOf(Object ... values) {
        HashSet<ColumnValues> ret = new HashSet<ColumnValues>();
        for (Object val : values) {
            ret.add(new ColumnValues(val));
        }
        return ret;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void add(Object value) {
        this.add(null, value);
    }

    public void add(String colName, Object value) {
        this.columns.add(new Column(colName, value));
    }

    public Column getColumnByName(String columnName) {
        int idx = -1;
        int i = 0;
        for (Column c : this.columns) {
            if (columnName.equalsIgnoreCase(c.getName())) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx < 0) {
            return null;
        }
        return this.columns.get(idx);
    }

    @Override
    public Iterator<Column> iterator() {
        return this.columns.iterator();
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ColumnValues)) {
            return false;
        }
        ColumnValues o = (ColumnValues)other;
        return this.columns.equals(o.columns);
    }

    public String toString() {
        return "ColumnValues" + this.columns.toString();
    }

    public ColumnValues clone() {
        ColumnValues ret = new ColumnValues();
        for (Column c : this.getColumns()) {
            ret.add(c.getName(), c.getValue());
        }
        return ret;
    }

    public static class Column {
        private String name;
        private Object value;

        private Column(String name, Object value) {
            this.name = name == null ? null : name.toUpperCase();
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name == null ? null : name.toUpperCase();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public int hashCode() {
            if (this.name != null) {
                return this.name.hashCode();
            }
            if (this.value != null) {
                return this.value.hashCode();
            }
            return 1;
        }

        public boolean equals(Object other) {
            boolean nameEquals;
            if (!(other instanceof Column)) {
                return false;
            }
            Column o = (Column)other;
            boolean bl = this.name == null ? o.name == null : (nameEquals = this.name.equalsIgnoreCase(o.name));
            boolean valueEquals = this.value == null ? o.value == null : this.value.equals(o.value);
            return nameEquals && valueEquals;
        }

        public String toString() {
            return "Column[name='" + this.name + "', value='" + this.value + "']";
        }
    }
}

