/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.helpers.perftest.support.jpa.Annotations;
import org.rhq.helpers.perftest.support.jpa.DependencyType;
import org.rhq.helpers.perftest.support.jpa.Edge;
import org.rhq.helpers.perftest.support.jpa.JPAUtil;
import org.rhq.helpers.perftest.support.jpa.Node;
import org.rhq.helpers.perftest.support.jpa.mapping.MappingTranslator;

public class EntityDependencyGraph {
    private static final Log LOG = LogFactory.getLog(EntityDependencyGraph.class);
    Map<Node, Node> nodes = new HashMap<Node, Node>();
    private MappingTranslator mappingTranslator = new MappingTranslator();

    public Node addEntity(Class<?> entity) {
        Node n = new Node(entity);
        n = this.analyze(n);
        this.translateEverything();
        return n;
    }

    public Set<Node> addEntities(Class<?> ... entities) {
        return this.addEntities(Arrays.asList(entities));
    }

    public Set<Node> addEntities(Collection<Class<?>> entities) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Class<?> e : entities) {
            ret.add(this.analyze(new Node(e)));
        }
        this.translateEverything();
        return ret;
    }

    public Set<Node> getAllNodes() {
        return this.nodes.keySet();
    }

    public Node getNode(Class<?> entityClass) {
        return this.nodes.get(new Node(entityClass));
    }

    public Set<Node> getRootNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes.keySet()) {
            if (!n.getParents(false).isEmpty()) continue;
            ret.add(n);
        }
        return ret;
    }

    public Set<Node> getLeafNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes.keySet()) {
            if (!n.getChildren(false).isEmpty()) continue;
            ret.add(n);
        }
        return ret;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("EntityDependencyGraph[\n");
        for (Node n : this.nodes.keySet()) {
            bld.append(n).append("\n");
        }
        bld.append("]");
        return bld.toString();
    }

    private void translateEverything() {
        for (Node n : this.getAllNodes()) {
            if (n.getTranslation() != null) continue;
            n.setTranslation(this.mappingTranslator.translate(n));
        }
        for (Node n : this.getAllNodes()) {
            for (Edge e : n.getEdges()) {
                if (e.getTranslation() != null) continue;
                e.setTranslation(this.mappingTranslator.translate(e));
            }
        }
    }

    private Node analyze(Node n) {
        Node existingNode = this.nodes.get(n);
        if (existingNode != null) {
            return existingNode;
        }
        if (!JPAUtil.isEntity(n.getEntity())) {
            return null;
        }
        this.nodes.put(n, n);
        Map<Field, Annotations> fields = JPAUtil.getJPAFields(n.getEntity());
        for (Map.Entry<Field, Annotations> entry : fields.entrySet()) {
            Field field = entry.getKey();
            Annotations annotations = entry.getValue();
            OneToOne oneToOne = annotations.get(OneToOne.class);
            ManyToOne manyToOne = annotations.get(ManyToOne.class);
            OneToMany oneToMany = annotations.get(OneToMany.class);
            ManyToMany manyToMany = annotations.get(ManyToMany.class);
            if (oneToOne != null) {
                this.analyzeOneToOne(n, field, annotations, oneToOne);
                continue;
            }
            if (manyToOne != null) {
                this.analyzeManyToOne(n, field, annotations, manyToOne);
                continue;
            }
            if (oneToMany != null) {
                this.analyzeOneToMany(n, field, annotations, oneToMany);
                continue;
            }
            if (manyToMany == null) continue;
            this.analyzeManyToMany(n, field, annotations, manyToMany);
        }
        return n;
    }

    private void analyzeOneToOne(Node n, Field field, Annotations annotations, OneToOne oneToOne) {
        try {
            Class targetEntity = oneToOne.targetEntity();
            Node target = this.getTargetNode(field, targetEntity);
            Field targetField = null;
            boolean forward = true;
            String mappedBy = oneToOne.mappedBy();
            if (!mappedBy.isEmpty()) {
                targetField = JPAUtil.getField(target.getEntity(), mappedBy);
                forward = false;
            } else {
                Set<Field> possibleTargetFields = JPAUtil.getJPAFields(target.getEntity(), OneToOne.class);
                for (Field f : possibleTargetFields) {
                    if (!n.getEntity().equals(this.getRelevantType(f, null)) || !f.getAnnotation(OneToOne.class).mappedBy().equals(field.getName())) continue;
                    targetField = f;
                    break;
                }
            }
            if (forward) {
                n.addChild(target, targetField, field, DependencyType.ONE_TO_ONE);
            } else {
                n.addParent(target, targetField, field, DependencyType.ONE_TO_ONE);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to analyze a @OneToOne relationship '" + field.getName() + "' on " + n.getEntity()), (Throwable)e);
        }
    }

    private void analyzeManyToOne(Node n, Field field, Annotations annotations, ManyToOne manyToOne) {
        Class targetEntity = manyToOne.targetEntity();
        Node target = this.getTargetNode(field, targetEntity);
        Field targetField = null;
        Set<Field> possibleTargetFields = JPAUtil.getJPAFields(target.getEntity(), OneToMany.class);
        for (Field f : possibleTargetFields) {
            if (!f.getAnnotation(OneToMany.class).mappedBy().equals(field.getName()) || !n.getEntity().equals(this.getRelevantType(f, null))) continue;
            targetField = f;
            break;
        }
        n.addParent(target, targetField, field, DependencyType.ONE_TO_MANY);
    }

    private void analyzeOneToMany(Node n, Field field, Annotations annotations, OneToMany oneToMany) {
        Class targetEntity = oneToMany.targetEntity();
        Node target = this.getTargetNode(field, targetEntity);
        Field targetField = null;
        if (!oneToMany.mappedBy().isEmpty()) {
            targetField = JPAUtil.getField(target.getEntity(), oneToMany.mappedBy());
        }
        n.addChild(target, targetField, field, DependencyType.ONE_TO_MANY);
    }

    private void analyzeManyToMany(Node n, Field field, Annotations annotations, ManyToMany manyToMany) {
        Class targetEntity = manyToMany.targetEntity();
        Node target = this.getTargetNode(field, targetEntity);
        Field targetField = null;
        boolean forward = true;
        Set<Field> possibleTargetFields = JPAUtil.getJPAFields(target.getEntity(), ManyToMany.class);
        String thisMappedBy = manyToMany.mappedBy();
        for (Field f : possibleTargetFields) {
            if (thisMappedBy.equals(f.getName())) {
                targetField = f;
                forward = false;
                break;
            }
            if (!f.getAnnotation(ManyToMany.class).mappedBy().equals(field.getName())) continue;
            targetField = f;
            break;
        }
        if (forward) {
            n.addChild(target, targetField, field, DependencyType.MANY_TO_MANY);
        } else {
            n.addParent(target, targetField, field, DependencyType.MANY_TO_MANY);
        }
    }

    private Class<?> getRelevantType(Field field, Class<?> declaredTargetEntity) {
        if (declaredTargetEntity == null || declaredTargetEntity == Void.TYPE) {
            declaredTargetEntity = field.getType();
        }
        if (EntityDependencyGraph.isCollection(declaredTargetEntity)) {
            Type type = field.getGenericType();
            declaredTargetEntity = EntityDependencyGraph.getCollectionTypeParameter(type, 0);
        } else if (EntityDependencyGraph.isMap(declaredTargetEntity)) {
            Type type = field.getGenericType();
            declaredTargetEntity = EntityDependencyGraph.getCollectionTypeParameter(type, 1);
        }
        return declaredTargetEntity;
    }

    private Node getTargetNode(Field field, Class<?> declaredTargetEntity) {
        declaredTargetEntity = this.getRelevantType(field, declaredTargetEntity);
        return this.analyze(new Node(declaredTargetEntity));
    }

    private static boolean isCollection(Class<?> clazz) {
        return clazz == Collection.class || clazz == List.class || clazz == Set.class;
    }

    private static boolean isMap(Class<?> clazz) {
        return clazz == Map.class;
    }

    private static Class<?> getCollectionTypeParameter(Type collectionType, int parameterPosition) {
        if (collectionType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
            return EntityDependencyGraph.resolveTypeParameter(typeArguments[parameterPosition]);
        }
        return (Class)collectionType;
    }

    private static Class<?> resolveTypeParameter(Type typeParameter) {
        if (typeParameter instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)typeParameter).getUpperBounds();
            if (upperBounds.length > 1) {
                return Object.class;
            }
            return (Class)upperBounds[0];
        }
        return (Class)typeParameter;
    }
}

