/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.input;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.rhq.helpers.perftest.support.input.CsvInput;
import org.rhq.helpers.perftest.support.input.ZipInputStreamProviderDecorator;

public class ZippedCsvInput
extends CsvInput {
    private ZipInputStreamProviderDecorator sourceFile;

    public ZippedCsvInput(ZipInputStreamProviderDecorator zipFileProvider) throws IOException {
        super(ZippedCsvInput.createTempDirectory());
        this.sourceFile = zipFileProvider;
    }

    @Override
    public void close() throws IOException {
        super.close();
        ZippedCsvInput.delete(this.getDirectory());
    }

    @Override
    public IDataSetProducer getProducer() throws Exception {
        if (this.getCsvProducer() == null) {
            ZippedCsvInput.unzip(this.sourceFile.createInputStream(), this.getDirectory());
        }
        return super.getProducer();
    }

    private static File createTempDirectory() throws IOException {
        File tmpFile = File.createTempFile("perftest-support-csv-output", null);
        tmpFile.delete();
        tmpFile.mkdir();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(ZipInputStream zipFile, File target) throws RuntimeException, IOException {
        ZipEntry entry = null;
        while ((entry = zipFile.getNextEntry()) != null) {
            File f = new File(target, entry.getName());
            if (entry.isDirectory()) {
                f.mkdirs();
                continue;
            }
            String parentDirectory = f.getParent();
            File parentDirectoryFile = new File(parentDirectory);
            parentDirectoryFile.mkdirs();
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(f));
            try {
                ZippedCsvInput.copy(zipFile, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
    }

    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                ZippedCsvInput.delete(child);
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        input = new BufferedInputStream(input, bufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = input.read(buffer);
        while (bytesRead != -1) {
            output.write(buffer, 0, bytesRead);
            numBytesCopied += (long)bytesRead;
            bytesRead = input.read(buffer);
        }
        output.flush();
    }
}

