/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.config;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.helpers.perftest.support.config.Entity;
import org.rhq.helpers.perftest.support.config.Relationship;
import org.rhq.helpers.perftest.support.jpa.Edge;
import org.rhq.helpers.perftest.support.jpa.EntityDependencyGraph;
import org.rhq.helpers.perftest.support.jpa.Node;

@XmlRootElement(name="graph")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExportConfiguration {
    @XmlElement(name="entity")
    private Set<Entity> entity = new HashSet<Entity>();
    @XmlAttribute
    private String packagePrefix;
    @XmlAttribute
    private Boolean includeExplicitDependentsImplicitly;
    @XmlTransient
    private Properties settings;

    public Set<Entity> getEntities() {
        return this.entity;
    }

    public void setEntities(Set<Entity> nodes) {
        this.entity = nodes;
    }

    public Class<?> getClassForEntity(Entity n) {
        String className = this.packagePrefix == null ? n.getName() : this.packagePrefix + "." + n.getName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(n.getName());
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    public Entity getEntity(Class<?> clazz) {
        for (Entity e : this.entity) {
            if (!this.getClassForEntity(e).equals(clazz)) continue;
            return e;
        }
        return null;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public boolean isIncludeExplicitDependentsImplicitly() {
        return this.includeExplicitDependentsImplicitly == null ? true : this.includeExplicitDependentsImplicitly;
    }

    public void setIncludeExplicitDependentsImplicitly(boolean includeExplicitDependentsImplicitly) {
        this.includeExplicitDependentsImplicitly = includeExplicitDependentsImplicitly;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public void setSettings(Properties settings) {
        this.settings = settings;
    }

    public static JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{ExportConfiguration.class, Entity.class, Relationship.class});
    }

    public static ExportConfiguration fromRealDependencyGraph(String packagePrefix, EntityDependencyGraph g) {
        ExportConfiguration ret = new ExportConfiguration();
        ret.setPackagePrefix(packagePrefix);
        HashMap<Node, Entity> realToSerialized = new HashMap<Node, Entity>();
        for (Node node : g.getAllNodes()) {
            Entity serialized = ExportConfiguration.fromRealNode(packagePrefix, node);
            realToSerialized.put(node, serialized);
            ret.getEntities().add(serialized);
        }
        for (Node node : g.getAllNodes()) {
            HashSet<Relationship> edges = new HashSet<Relationship>();
            for (Edge edge : node.getEdges()) {
                Relationship r;
                if (edge.getFrom() != node || (r = ExportConfiguration.fromRealEdge(node, edge, realToSerialized)) == null) continue;
                edges.add(r);
            }
            Entity serialized = (Entity)realToSerialized.get(node);
            serialized.setRelationships(edges);
        }
        return ret;
    }

    private static Entity fromRealNode(String packageNamePrefix, Node node) {
        String className = node.getEntity().getName();
        if (className.startsWith(packageNamePrefix)) {
            className = className.substring(packageNamePrefix.length() + 1);
        }
        Entity ret = new Entity();
        ret.setName(className);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Relationship fromRealEdge(Node currentNode, Edge edge, Map<Node, Entity> realToSerializedNodes) {
        Relationship ret = new Relationship();
        if (currentNode.equals(edge.getFrom())) {
            if (edge.getFromField() == null) return null;
            ret.setField(edge.getFromField().getName());
            return ret;
        } else {
            if (edge.getToField() == null) return null;
            ret.setField(edge.getToField().getName());
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ExportConfiguration.class, Entity.class, Relationship.class});
        Marshaller m = c.createMarshaller();
        EntityDependencyGraph edg = new EntityDependencyGraph();
        edg.addEntity(Class.forName("org.rhq.core.domain.resource.Resource"));
        m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
        m.marshal((Object)ExportConfiguration.fromRealDependencyGraph("org.rhq.core.domain", edg), (OutputStream)System.out);
    }
}

