/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.dbunit;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.rhq.helpers.perftest.support.jpa.ColumnValues;
import org.rhq.helpers.perftest.support.jpa.mapping.ColumnValuesTableMap;

public class EntityRelationshipTableIterator
implements ITableIterator {
    private ITableIterator wrappedIterator;
    private ColumnValuesTableMap allowedPks;

    public EntityRelationshipTableIterator(ITableIterator wrappedIterator, ColumnValuesTableMap allowedPks) {
        this.wrappedIterator = wrappedIterator;
        this.allowedPks = allowedPks;
    }

    public boolean next() throws DataSetException {
        while (this.wrappedIterator.next()) {
            if (!this.allowedPks.containsKey(this.wrappedIterator.getTableMetaData().getTableName().toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        return this.wrappedIterator.getTableMetaData();
    }

    public ITable getTable() throws DataSetException {
        String tableName = this.getTableMetaData().getTableName().toUpperCase();
        Set pks = (Set)this.allowedPks.get(tableName);
        ITable wrappedTable = this.wrappedIterator.getTable();
        if (pks == null) {
            return wrappedTable;
        }
        if (pks.isEmpty()) {
            return new EmptyTable(wrappedTable.getTableMetaData());
        }
        return new FilteredTable(wrappedTable, pks);
    }

    private class FilteredTable
    implements ITable {
        private ITable wrappedTable;
        private List<Integer> allowedRowNumbers;

        public FilteredTable(ITable wrappedTable, Set<ColumnValues> allowedPks) throws DataSetException {
            this.wrappedTable = wrappedTable;
            this.allowedRowNumbers = this.getRowNumbers(wrappedTable, allowedPks);
        }

        public ITableMetaData getTableMetaData() {
            return this.wrappedTable.getTableMetaData();
        }

        public int getRowCount() {
            return this.allowedRowNumbers.size();
        }

        public Object getValue(int row, String column) throws DataSetException {
            if (row >= this.allowedRowNumbers.size()) {
                throw new RowOutOfBoundsException();
            }
            return this.wrappedTable.getValue(this.allowedRowNumbers.get(row).intValue(), column);
        }

        private List<Integer> getRowNumbers(ITable table, Set<ColumnValues> pks) throws DataSetException {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            if (pks.isEmpty()) {
                return ret;
            }
            for (ColumnValues pk : pks) {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    boolean add = true;
                    for (ColumnValues.Column c : pk) {
                        Object val = table.getValue(i, c.getName());
                        if (!(c.getValue() == null ? val != null : !c.getValue().equals(val))) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    ret.add(i);
                }
            }
            return ret;
        }
    }

    private static class EmptyTable
    implements ITable {
        private ITableMetaData metadata;

        public EmptyTable(ITableMetaData metadata) {
            this.metadata = metadata;
        }

        public ITableMetaData getTableMetaData() {
            return this.metadata;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getValue(int row, String column) throws DataSetException {
            throw new RowOutOfBoundsException("This table is always empty.");
        }
    }
}

