/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.rhq.helpers.perftest.support.jpa.Edge;
import org.rhq.helpers.perftest.support.jpa.JPAUtil;
import org.rhq.helpers.perftest.support.jpa.Node;
import org.rhq.helpers.perftest.support.jpa.mapping.EntityTranslation;
import org.rhq.helpers.perftest.support.jpa.mapping.RelationshipTranslation;

public class MappingTranslator {
    public EntityTranslation translate(Node node) {
        EntityTranslation translation = new EntityTranslation();
        translation.setTableName(MappingTranslator.getTableName(node));
        translation.setPkColumns(MappingTranslator.getPkColumns(node));
        return translation;
    }

    public RelationshipTranslation translate(Edge edge) {
        switch (edge.getDependencyType()) {
            case ONE_TO_ONE: {
                return MappingTranslator.analyzeOneToOne(edge);
            }
            case ONE_TO_MANY: {
                return MappingTranslator.analyzeOneToMany(edge);
            }
            case MANY_TO_MANY: {
                return MappingTranslator.analyzeManyToMany(edge);
            }
        }
        return null;
    }

    private static String getTableName(Node node) {
        return MappingTranslator.getTableName(node.getEntity());
    }

    private static String[] getPkColumns(Node node) {
        Set<AnnotatedField> pkFields = MappingTranslator.getIdFields(node.getEntity());
        if (pkFields.isEmpty()) {
            return null;
        }
        String[] columns = new String[pkFields.size()];
        int idx = 0;
        for (AnnotatedField f : pkFields) {
            columns[idx] = MappingTranslator.getColumnName(f);
            if (columns[idx] == null) {
                ManyToOne manyToOne = f.getAnnotation(ManyToOne.class);
                if (manyToOne == null) {
                    columns[idx] = f.getName().toUpperCase();
                } else {
                    JoinColumn joinColumn = f.getAnnotation(JoinColumn.class);
                    columns[idx] = joinColumn.name();
                    if (columns[idx].isEmpty()) {
                        columns[idx] = f.getName().toUpperCase();
                    }
                }
            }
            ++idx;
        }
        return columns;
    }

    private static String getColumnName(Field field) {
        if (field == null) {
            return null;
        }
        Column colSpec = field.getAnnotation(Column.class);
        if (colSpec != null && !colSpec.name().isEmpty()) {
            return colSpec.name();
        }
        return null;
    }

    private static List<JoinColumn> getJoinColumns(Field field) {
        if (field == null) {
            return null;
        }
        JoinColumn colSpec = field.getAnnotation(JoinColumn.class);
        if (colSpec != null) {
            return Collections.singletonList(colSpec);
        }
        JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
        if (joinColumns != null) {
            JoinColumn[] cols = joinColumns.value();
            ArrayList<JoinColumn> ret = new ArrayList<JoinColumn>();
            for (int i = 0; i < cols.length; ++i) {
                ret.add(cols[i]);
            }
            return ret;
        }
        return null;
    }

    private static String[] referencedJoinColumnNames(Field field) {
        if (field == null) {
            return null;
        }
        JoinColumn colSpec = field.getAnnotation(JoinColumn.class);
        if (colSpec != null) {
            return new String[]{colSpec.referencedColumnName().toUpperCase()};
        }
        JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
        if (joinColumns != null) {
            JoinColumn[] cols = joinColumns.value();
            String[] ret = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                ret[i] = cols[i].referencedColumnName().toUpperCase();
            }
            return ret;
        }
        return null;
    }

    private static String getColumnName(AnnotatedField field) {
        if (field == null) {
            return null;
        }
        Column colSpec = field.getAnnotation(Column.class);
        if (colSpec != null && !colSpec.name().isEmpty()) {
            return colSpec.name().toUpperCase();
        }
        return null;
    }

    public static String getTableName(Class<?> entity) {
        Table tableAnnotation = entity.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            String name = tableAnnotation.name();
            if (name.isEmpty()) {
                name = entity.getSimpleName();
            }
            return name.toUpperCase();
        }
        DiscriminatorValue discriminatorValueAnnotation = entity.getAnnotation(DiscriminatorValue.class);
        if (discriminatorValueAnnotation != null) {
            return MappingTranslator.getTableName(entity.getSuperclass());
        }
        return null;
    }

    public static Set<AnnotatedField> getIdFields(Class<?> entity) {
        Set<Field> idFields = JPAUtil.getJPAFields(entity, Id.class);
        if (idFields.size() == 0) {
            return null;
        }
        if (idFields.size() == 1) {
            return Collections.singleton(new AnnotatedField(idFields.iterator().next()));
        }
        Class idClass = entity.getAnnotation(IdClass.class).value();
        HashSet<AnnotatedField> ret = new HashSet<AnnotatedField>();
        for (Field f : idFields) {
            AnnotatedField af = new AnnotatedField(f);
            try {
                Field idF = idClass.getDeclaredField(f.getName());
                af.addAnnotations(idF.getAnnotations());
            }
            catch (Exception e) {
                // empty catch block
            }
            ret.add(af);
        }
        return ret;
    }

    private static RelationshipTranslation analyzeOneToOne(Edge relationship) {
        Field fromField = relationship.getFromField();
        Field toField = relationship.getToField();
        RelationshipTranslation translation = new RelationshipTranslation();
        List<JoinColumn> joins = MappingTranslator.getJoinColumns(fromField);
        String[] fCols = new String[joins.size()];
        String[] tCols = new String[joins.size()];
        int i = 0;
        for (JoinColumn c : joins) {
            String fkey = c.name().toUpperCase();
            String refCol = c.referencedColumnName().toUpperCase();
            if (toField == null) {
                fCols[i] = fkey;
                if (!refCol.isEmpty()) {
                    tCols[i] = refCol;
                }
            } else if (refCol.isEmpty()) {
                fCols[i] = fkey;
            } else {
                fCols[i] = fkey;
                tCols[i] = refCol;
            }
            ++i;
        }
        String[] fromPks = relationship.getFrom().getTranslation().getPkColumns();
        for (i = 0; i < fCols.length; ++i) {
            if (fCols[i] != null) continue;
            fCols[i] = fromPks[i];
        }
        String[] toPks = relationship.getTo().getTranslation().getPkColumns();
        for (i = 0; i < tCols.length; ++i) {
            if (tCols[i] != null) continue;
            tCols[i] = toPks[i];
        }
        translation.setFromColumns(fCols);
        translation.setToColumns(tCols);
        return translation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RelationshipTranslation analyzeOneToMany(Edge relationship) {
        Field fromField = relationship.getFromField();
        Field toField = relationship.getToField();
        RelationshipTranslation translation = new RelationshipTranslation();
        if (toField == null) {
            JoinTable t = fromField.getAnnotation(JoinTable.class);
            JoinColumn c = fromField.getAnnotation(JoinColumn.class);
            if (t != null) {
                MappingTranslator.analyzeJoinTable(translation, t);
                return translation;
            } else {
                if (c == null) throw new IllegalArgumentException("Default mappings on @OneToMany not implemented.");
                String fromColumn = MappingTranslator.getColumnName(fromField);
                if (fromColumn == null) {
                    translation.setFromColumns(relationship.getFrom().getTranslation().getPkColumns());
                } else {
                    translation.setFromColumns(new String[]{fromColumn});
                }
                translation.setToColumns(MappingTranslator.joinColumnNames(new JoinColumn[]{c}));
            }
            return translation;
        } else {
            String fromColumn = MappingTranslator.getColumnName(fromField);
            if (fromColumn == null) {
                translation.setFromColumns(relationship.getFrom().getTranslation().getPkColumns());
            } else {
                translation.setFromColumns(new String[]{fromColumn});
            }
            String toColumn = MappingTranslator.getColumnName(toField);
            if (toColumn == null) {
                AnnotatedField fullField = MappingTranslator.getFieldWithFullAnnotations(toField);
                JoinColumn joinColumn = fullField.getAnnotation(JoinColumn.class);
                if (joinColumn == null) {
                    translation.setToColumns(relationship.getTo().getTranslation().getPkColumns());
                    return translation;
                } else {
                    translation.setToColumns(MappingTranslator.joinColumnNames(new JoinColumn[]{joinColumn}));
                }
                return translation;
            } else {
                translation.setToColumns(new String[]{toColumn});
            }
        }
        return translation;
    }

    private static RelationshipTranslation analyzeManyToMany(Edge relationship) {
        Field fromField = relationship.getFromField();
        Field toField = relationship.getToField();
        JoinTable t = fromField.getAnnotation(JoinTable.class);
        if (t == null) {
            t = toField.getAnnotation(JoinTable.class);
        }
        if (t == null) {
            throw new IllegalStateException("Default values for a @JoinTable are not supported.");
        }
        RelationshipTranslation translation = new RelationshipTranslation();
        MappingTranslator.analyzeJoinTable(translation, t);
        return translation;
    }

    private static void analyzeJoinTable(RelationshipTranslation translation, JoinTable joinTable) {
        JoinColumn[] joinCols = joinTable.joinColumns();
        JoinColumn[] inverseCols = joinTable.inverseJoinColumns();
        String tableName = joinTable.name().toUpperCase();
        translation.setRelationTable(tableName);
        translation.setRelationTableFromColumns(MappingTranslator.joinColumnNames(joinCols));
        translation.setRelationTableToColumns(MappingTranslator.joinColumnNames(inverseCols));
        translation.setFromColumns(new String[joinCols.length]);
        translation.setToColumns(new String[inverseCols.length]);
        MappingTranslator.updateWithJoinColumnReferencedNames(translation.getFromColumns(), joinCols);
        MappingTranslator.updateWithJoinColumnReferencedNames(translation.getToColumns(), inverseCols);
    }

    private static String[] joinColumnNames(JoinColumn[] columns) {
        String[] ret = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            ret[i] = columns[i].name().toUpperCase();
        }
        return ret;
    }

    private static void updateWithJoinColumnReferencedNames(String[] names, JoinColumn[] columns) {
        if (names.length != columns.length) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].referencedColumnName().isEmpty()) continue;
            names[i] = columns[i].referencedColumnName().toUpperCase();
        }
    }

    private static AnnotatedField getFieldWithFullAnnotations(Field f) {
        AnnotatedField ret = new AnnotatedField(f);
        IdClass idClass = f.getDeclaringClass().getAnnotation(IdClass.class);
        if (idClass != null) {
            try {
                Field correspondingIdField = idClass.value().getDeclaredField(f.getName());
                ret.addAnnotations(correspondingIdField.getAnnotations());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private static class AnnotatedField {
        private Field field;
        private Annotation[] annotations;

        public AnnotatedField(Field f) {
            this.field = f;
            this.annotations = new Annotation[f.getAnnotations().length];
            System.arraycopy(f.getAnnotations(), 0, this.annotations, 0, this.annotations.length);
        }

        public void addAnnotations(Annotation[] annotations) {
            Annotation[] thisAnnotations = this.annotations;
            this.annotations = new Annotation[this.annotations.length + annotations.length];
            System.arraycopy(thisAnnotations, 0, this.annotations, 0, thisAnnotations.length);
            System.arraycopy(annotations, 0, this.annotations, thisAnnotations.length, annotations.length);
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        public <T extends Annotation> T getAnnotation(Class<T> type) {
            for (int i = 0; i < this.annotations.length; ++i) {
                if (!this.annotations[i].annotationType().equals(type)) continue;
                return (T)((Annotation)type.cast(this.annotations[i]));
            }
            return null;
        }

        public String getName() {
            return this.field.getName();
        }
    }
}

