/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.output;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.rhq.helpers.perftest.support.output.CsvOutput;

public class ZippedCsvOutput
extends CsvOutput {
    private File targetFile;

    public ZippedCsvOutput(File file) throws IOException {
        super(ZippedCsvOutput.createTempDirectory());
        this.targetFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        ZipOutputStream stream = null;
        try {
            stream = new ZipOutputStream(new FileOutputStream(this.targetFile));
            ZippedCsvOutput.zipFileOrDir(super.getDirectory(), stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            ZippedCsvOutput.delete(super.getDirectory());
        }
    }

    private static File createTempDirectory() throws IOException {
        File tmpFile = File.createTempFile("perftest-support-csv-output", null);
        tmpFile.delete();
        tmpFile.mkdir();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFileOrDir(File f, ZipOutputStream zipFile) throws IOException {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                ZippedCsvOutput.zipFileOrDir(child, zipFile);
            }
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                ZipEntry zipEntry = new ZipEntry(f.getPath());
                zipFile.putNextEntry(zipEntry);
                ZippedCsvOutput.copy(fis, zipFile);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        long numBytesCopied = 0L;
        int bufferSize = 32768;
        input = new BufferedInputStream(input, bufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = input.read(buffer);
        while (bytesRead != -1) {
            output.write(buffer, 0, bytesRead);
            numBytesCopied += (long)bytesRead;
            bytesRead = input.read(buffer);
        }
        output.flush();
    }

    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                ZippedCsvOutput.delete(child);
            }
            f.delete();
        } else {
            f.delete();
        }
    }
}

