/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import org.rhq.helpers.perftest.support.jpa.Annotations;

public class JPAUtil {
    private JPAUtil() {
    }

    public static boolean isEntity(Class<?> clazz) {
        return clazz.getAnnotation(Entity.class) != null;
    }

    public static Annotations getJPAAnnotations(Class<?> clazz) {
        return JPAUtil.extractJPAAnnotations(clazz.getAnnotations());
    }

    public static Annotations getJPAAnnotations(Field field) {
        return JPAUtil.extractJPAAnnotations(field.getAnnotations());
    }

    public static Map<Field, Annotations> getJPAFields(Class<?> clazz) {
        HashMap<Field, Annotations> ret = new HashMap<Field, Annotations>();
        for (Field f : JPAUtil.getAllFields(clazz)) {
            if (f.getAnnotation(Embedded.class) == null) {
                ret.put(f, JPAUtil.extractJPAAnnotations(f.getAnnotations()));
                continue;
            }
            ret.putAll(JPAUtil.getJPAFields(f.getType()));
        }
        return ret;
    }

    public static Set<Field> getJPAFields(Class<?> clazz, Class<? extends Annotation> desiredAnnotation) {
        HashSet<Field> ret = new HashSet<Field>();
        for (Field f : JPAUtil.getAllFields(clazz)) {
            if (f.getAnnotation(desiredAnnotation) != null) {
                ret.add(f);
                continue;
            }
            if (f.getAnnotation(Embedded.class) == null) continue;
            ret.addAll(JPAUtil.getJPAFields(f.getType(), desiredAnnotation));
        }
        return ret;
    }

    private static Annotations extractJPAAnnotations(Annotation[] annotations) {
        Annotations ret = new Annotations();
        for (Annotation annon : annotations) {
            if (!annon.annotationType().getPackage().getName().startsWith("javax.persistence")) continue;
            ret.put(annon.annotationType(), annon);
        }
        return ret;
    }

    public static Field getField(Class<?> clazz, String name) {
        while (clazz != null) {
            Field f = null;
            try {
                f = clazz.getDeclaredField(name);
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (f != null) {
                return f;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            fields.addAll(JPAUtil.getAllFields(clazz.getSuperclass()));
        }
        return fields;
    }
}

