/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.perftest.support.jpa;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.rhq.helpers.perftest.support.jpa.DependencyType;
import org.rhq.helpers.perftest.support.jpa.Edge;
import org.rhq.helpers.perftest.support.jpa.mapping.EntityTranslation;

public class Node
implements Comparable<Node> {
    private Class<?> entity;
    private Set<Edge> edges;
    private EntityTranslation translation;

    public Node(Class<?> entity) {
        this.entity = entity;
        this.edges = new HashSet<Edge>();
    }

    public Class<?> getEntity() {
        return this.entity;
    }

    public EntityTranslation getTranslation() {
        return this.translation;
    }

    public void setTranslation(EntityTranslation translation) {
        this.translation = translation;
    }

    public void addParent(Node parent, Field parentField, Field thisField, DependencyType dependencyType) {
        Edge edge = new Edge(parent, this, parentField, thisField, dependencyType);
        if (this.edges.add(edge)) {
            parent.addEdge(edge);
        }
    }

    public void addChild(Node child, Field childField, Field thisField, DependencyType dependencyType) {
        Edge edge = new Edge(this, child, thisField, childField, dependencyType);
        if (this.edges.add(edge)) {
            child.addEdge(edge);
        }
    }

    protected void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Set<Edge> getOutgoingEdges() {
        HashSet<Edge> ret = new HashSet<Edge>();
        for (Edge e : this.edges) {
            if (this != e.getFrom()) continue;
            ret.add(e);
        }
        return ret;
    }

    public Set<Edge> getIncomingEdges() {
        HashSet<Edge> ret = new HashSet<Edge>();
        for (Edge e : this.edges) {
            if (this != e.getTo()) continue;
            ret.add(e);
        }
        return ret;
    }

    public SortedSet<Node> getParents(boolean onlyExplicitRelations) {
        TreeSet<Node> ret = new TreeSet<Node>();
        for (Edge e : this.edges) {
            if (e.getTo() != this || onlyExplicitRelations && e.getFromField() == null) continue;
            ret.add(e.getFrom());
        }
        return ret;
    }

    public SortedSet<Node> getChildren(boolean onlyExplicitRelations) {
        TreeSet<Node> ret = new TreeSet<Node>();
        for (Edge e : this.edges) {
            if (e.getFrom() != this || onlyExplicitRelations && e.getToField() == null) continue;
            ret.add(e.getTo());
        }
        return ret;
    }

    public SortedSet<Node> getTransitiveParents(boolean onlyExplicitRelations) {
        TreeSet<Node> ret = new TreeSet<Node>();
        ret.add(this);
        SortedSet<Node> currentParents = this.getParents(onlyExplicitRelations);
        while (!currentParents.isEmpty()) {
            HashSet<Node> parentsCopy = new HashSet<Node>(currentParents);
            if (!ret.addAll(currentParents)) break;
            currentParents.clear();
            for (Node p : parentsCopy) {
                currentParents.addAll(p.getParents(onlyExplicitRelations));
            }
        }
        return ret;
    }

    public SortedSet<Node> getTransitiveChildren(boolean onlyExplicitRelations) {
        TreeSet<Node> ret = new TreeSet<Node>();
        ret.add(this);
        SortedSet<Node> currentChildren = this.getChildren(onlyExplicitRelations);
        while (!currentChildren.isEmpty()) {
            HashSet<Node> childrenCopy = new HashSet<Node>(currentChildren);
            if (!ret.addAll(currentChildren)) break;
            currentChildren.clear();
            for (Node c : childrenCopy) {
                currentChildren.addAll(c.getChildren(onlyExplicitRelations));
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Node)) {
            return false;
        }
        return this.entity.equals(((Node)other).getEntity());
    }

    @Override
    public int compareTo(Node o) {
        return this.entity.getName().compareTo(o.entity.getName());
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.entity.getSimpleName()).append("[\n");
        bld.append("attachment=").append(this.translation).append("\n");
        for (Edge e : this.edges) {
            String toField;
            String fromField = e.getFromField() != null ? e.getFromField().getName() : "?";
            String string = toField = e.getToField() != null ? e.getToField().getName() : "?";
            if (e.getFrom() == this) {
                bld.append("(").append(fromField);
                bld.append(") -").append((Object)e.getDependencyType()).append("> ").append(e.getTo().getEntity().getSimpleName());
                bld.append("(").append(toField).append(")");
            } else {
                bld.append("(").append(toField);
                bld.append(") <").append((Object)e.getDependencyType()).append("- ").append(e.getFrom().getEntity().getSimpleName());
                bld.append("(").append(fromField).append(")");
            }
            bld.append("\n").append("(attachment=").append(e.getTranslation()).append(")\n");
        }
        bld.append("]");
        return bld.toString();
    }
}

