/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.rest_docs_generator;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiProperty;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resteasy.annotations.GZIP;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SupportedOptions(value={"targetDirectory", "verbose", "modelPkg", "skipPkg"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.wordnik.swagger.annotations.*", "javax.ws.rs.*", "javax.xml.bind.annotation.XmlRootElement"})
public class ClassLevelProcessor
extends AbstractProcessor {
    private static final String JAVAX_WS_RS = "javax.ws.rs";
    private static final String[] HTTP_METHODS = new String[]{"GET", "PUT", "POST", "HEAD", "DELETE", "OPTIONS"};
    private static final String[] PARAM_SKIP_ANNOTATIONS = new String[]{"javax.ws.rs.core.UriInfo", "javax.ws.rs.core.HttpHeaders", "javax.servlet.http.HttpServletRequest", "javax.ws.rs.core.Request"};
    private static final String API_OUT_XML = "rest-api-out.xml";
    public static final String TARGET_DIRECTORY = "targetDirectory";
    public static final String VERBOSE = "verbose";
    private static final String BODY_INDICATOR = "-body-";
    public static final String MODEL_PACKAGE_KEY = "modelPkg";
    public static final String SKIP_PACKAGE_KEY = "skipPkg";
    public String modelPackage = "org.rhq.enterprise.server.rest.domain";
    public String skipPackage = "org.rhq.enterprise.server.rest.reporting";
    Log log = LogFactory.getLog((String)this.getClass().getName());
    private String targetDirectory;
    boolean verbose = false;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Map<String, String> options = this.processingEnv.getOptions();
        if (options.containsKey(TARGET_DIRECTORY)) {
            this.targetDirectory = options.get(TARGET_DIRECTORY);
            System.out.println("== Target directory is set to " + this.targetDirectory);
        }
        if (options.containsKey(VERBOSE)) {
            this.verbose = true;
        }
        if (options.containsKey(MODEL_PACKAGE_KEY)) {
            this.modelPackage = options.get(MODEL_PACKAGE_KEY);
            System.out.println("== Found a model package of " + this.modelPackage);
        }
        if (options.containsKey(SKIP_PACKAGE_KEY)) {
            this.skipPackage = options.get(SKIP_PACKAGE_KEY);
            System.out.println("== Found a skip package of " + this.skipPackage);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Document doc;
        if (roundEnv.processingOver()) {
            return true;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = documentBuilder.newDocument();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
        Element root = doc.createElement("api");
        doc.appendChild(root);
        for (javax.lang.model.element.Element element : roundEnv.getRootElements()) {
            this.processClass(doc, root, (TypeElement)element);
        }
        try {
            File f;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            if (this.verbose) {
                System.out.println(xmlString);
            }
            if (this.targetDirectory != null) {
                boolean success;
                File targetDir = new File(this.targetDirectory);
                if (!targetDir.exists() && !(success = targetDir.mkdirs())) {
                    this.log.warn((Object)("Creation of target directory " + this.targetDirectory + " failed"));
                }
                f = new File(targetDir, API_OUT_XML);
            } else {
                f = new File(API_OUT_XML);
            }
            String path = f.getAbsolutePath();
            String s = "..... writing to [" + path + "] ......";
            if (this.verbose) {
                System.out.println(s);
            } else {
                this.log.info((Object)s);
            }
            try {
                FileWriter fw = new FileWriter(f);
                fw.write(xmlString);
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
        }
        return true;
    }

    private void processClass(Document doc, Element xmlRoot, TypeElement classElementIn) {
        Produces produces;
        this.log.debug((Object)("Looking at " + classElementIn.getQualifiedName().toString()));
        if (classElementIn.getQualifiedName().toString().startsWith(this.skipPackage)) {
            this.log.debug((Object)" .. skipping ..");
            return;
        }
        if (classElementIn.getAnnotation(ApiClass.class) != null) {
            this.processDataClass(doc, classElementIn, xmlRoot);
            return;
        }
        Path basePath = classElementIn.getAnnotation(Path.class);
        if (basePath == null || basePath.value().isEmpty()) {
            this.log.debug((Object)("No @Path found on " + classElementIn.getQualifiedName() + " - skipping"));
            return;
        }
        Element classElement = doc.createElement("class");
        String className = classElementIn.toString();
        classElement.setAttribute("name", className);
        String value = basePath.value();
        value = this.cleanOutPath(value);
        classElement.setAttribute("path", value);
        Api api = classElementIn.getAnnotation(Api.class);
        if (api != null) {
            String shortDescription = api.value();
            this.setOptionalAttribute(classElement, "shortDesc", shortDescription);
            String longDescription = api.description();
            this.setOptionalAttribute(classElement, "description", longDescription);
            String basePathAttr = api.basePath();
            this.setOptionalAttribute(classElement, "basePath", basePathAttr);
        }
        if ((produces = classElementIn.getAnnotation(Produces.class)) != null) {
            String[] types = produces.value();
            Element pElement = doc.createElement("produces");
            classElement.appendChild(pElement);
            for (String type : types) {
                Element tElement = doc.createElement("type");
                pElement.appendChild(tElement);
                tElement.setTextContent(type);
            }
        }
        xmlRoot.appendChild(classElement);
        for (ExecutableElement m : ElementFilter.methodsIn(classElementIn.getEnclosedElements())) {
            this.processMethods(doc, m, classElement);
        }
    }

    private void processMethods(Document doc, ExecutableElement td, Element classElement) {
        this.log.debug((Object)("  Looking at method " + td.getSimpleName().toString()));
        Path pathAnnotation = td.getAnnotation(Path.class);
        if (pathAnnotation == null) {
            return;
        }
        String path = pathAnnotation.value();
        path = this.cleanOutPath(path);
        Element methodElement = doc.createElement("method");
        methodElement.setAttribute("path", path);
        classElement.appendChild(methodElement);
        Name elementName = td.getSimpleName();
        methodElement.setAttribute("name", elementName.toString());
        String httpMethod = this.getHttpMethod(td.getAnnotationMirrors());
        methodElement.setAttribute("method", httpMethod);
        GZIP gzip = td.getAnnotation(GZIP.class);
        if (gzip != null) {
            methodElement.setAttribute("gzip", "true");
        }
        ApiOperation apiOperation = td.getAnnotation(ApiOperation.class);
        String responseClass = null;
        if (apiOperation != null) {
            String description = apiOperation.value();
            this.setOptionalAttribute(methodElement, "description", description);
            if (!apiOperation.responseClass().equals("void")) {
                responseClass = apiOperation.responseClass();
                if (apiOperation.multiValueResponse()) {
                    responseClass = responseClass + " (multi)";
                }
            }
        }
        if (responseClass == null) {
            responseClass = td.getReturnType().toString();
        }
        this.constructTypeNameAndAssign(methodElement, responseClass, "returnType");
        this.processParams(doc, td, methodElement);
        this.processErrors(doc, td, methodElement);
    }

    private void processParams(Document doc, ExecutableElement methodElement, Element parent) {
        for (VariableElement variableElement : methodElement.getParameters()) {
            DefaultValue dva;
            String defaultValue;
            String name;
            TypeMirror t = variableElement.asType();
            if (this.skipParamType(t)) continue;
            Element element = doc.createElement("param");
            parent.appendChild(element);
            String paramType = BODY_INDICATOR;
            PathParam pp = variableElement.getAnnotation(PathParam.class);
            QueryParam qp = variableElement.getAnnotation(QueryParam.class);
            ApiParam ap = variableElement.getAnnotation(ApiParam.class);
            if (pp != null) {
                name = pp.value();
                paramType = "Path";
            } else if (qp != null) {
                name = qp.value();
                paramType = "Query";
            } else if (ap != null) {
                name = ap.name();
            } else {
                Name nameElement = variableElement.getSimpleName();
                name = nameElement.toString();
            }
            element.setAttribute("name", name);
            element.setAttribute("paramType", paramType);
            ApiParam apiParam = variableElement.getAnnotation(ApiParam.class);
            if (apiParam != null) {
                String description = apiParam.value();
                this.setOptionalAttribute(element, "description", description);
                String required = String.valueOf(apiParam.required());
                if (pp != null || paramType.equals(BODY_INDICATOR)) {
                    required = "true";
                }
                this.setOptionalAttribute(element, "required", required, "false");
                String allowedValues = apiParam.allowableValues();
                this.setOptionalAttribute(element, "allowableValues", allowedValues, "all");
            }
            if ((defaultValue = (dva = variableElement.getAnnotation(DefaultValue.class)) != null ? dva.value() : (ap != null ? ap.defaultValue() : "-none-")) != null) {
                element.setAttribute("defaultValue", defaultValue);
            }
            String typeString = t.toString();
            this.constructTypeNameAndAssign(element, typeString, "type");
        }
    }

    private void constructTypeNameAndAssign(Element element, String typeString, String attributeName) {
        String typeId = typeString;
        if (typeString.contains("java.lang.")) {
            typeString = typeString.replaceAll("java\\.lang\\.", "");
        } else if (typeString.contains("java.util.")) {
            typeString = typeString.replaceAll("java\\.util\\.", "");
        }
        if (typeString.contains(this.modelPackage)) {
            String mps = this.modelPackage.endsWith(".") ? this.modelPackage : this.modelPackage + ".";
            int offset = typeString.contains("<") ? typeString.indexOf(60) + 1 : 0;
            String restType = typeString.substring(offset + this.modelPackage.length() + 1);
            if (restType.endsWith(">")) {
                restType = restType.substring(0, restType.length() - 1);
            }
            System.out.println("REST TYPE " + restType);
            typeString = typeString.replace(mps, "");
            typeId = "..." + restType;
        }
        element.setAttribute(attributeName, typeString);
        element.setAttribute(attributeName + "Id", typeId);
    }

    private void processErrors(Document doc, ExecutableElement methodElement, Element parent) {
        ApiError ae = methodElement.getAnnotation(ApiError.class);
        this.processError(doc, ae, parent);
        ApiErrors aes = methodElement.getAnnotation(ApiErrors.class);
        if (aes != null) {
            for (ApiError ae2 : aes.value()) {
                this.processError(doc, ae2, parent);
            }
        }
    }

    private void processError(Document doc, ApiError ae, Element parent) {
        if (ae == null) {
            return;
        }
        Element element = doc.createElement("error");
        parent.appendChild(element);
        element.setAttribute("code", String.valueOf(ae.code()));
        element.setAttribute("reason", ae.reason());
    }

    private void processDataClass(Document doc, TypeElement classElementIn, Element xmlRoot) {
        XmlRootElement rootElement;
        String pkg = classElementIn.toString();
        this.log.debug((Object)("Looking at " + pkg));
        if (!pkg.startsWith(this.modelPackage) || pkg.startsWith(this.skipPackage)) {
            this.log.debug((Object)" skipping as it does not meet the required package");
            return;
        }
        Element elem = doc.createElement("data");
        xmlRoot.appendChild(elem);
        elem.setAttribute("name", classElementIn.getSimpleName().toString());
        elem.setAttribute("nameId", "..." + classElementIn.getSimpleName().toString());
        ApiClass api = classElementIn.getAnnotation(ApiClass.class);
        if (api != null) {
            elem.setAttribute("abstract", api.value());
            if (api.description() != null && !api.description().isEmpty()) {
                elem.setAttribute("description", api.description());
            }
        }
        String objectName = (rootElement = classElementIn.getAnnotation(XmlRootElement.class)) != null ? rootElement.name() : classElementIn.getSimpleName().toString();
        elem.setAttribute("objectName", objectName);
        this.processDataClassProperties(doc, classElementIn, elem);
    }

    private void processDataClassProperties(Document doc, TypeElement classElementIn, Element elem) {
        for (ExecutableElement m : ElementFilter.methodsIn(classElementIn.getEnclosedElements())) {
            TypeMirror returnTypeMirror;
            String typeName;
            String mName = m.getSimpleName().toString();
            if (!mName.startsWith("get") && !mName.startsWith("is")) continue;
            Element mElem = doc.createElement("property");
            elem.appendChild(mElem);
            String pName = mName.startsWith("get") ? mName.substring(3) : mName.substring(2);
            pName = pName.substring(0, 1).toLowerCase() + pName.substring(1);
            mElem.setAttribute("name", pName);
            ApiProperty ap = m.getAnnotation(ApiProperty.class);
            if (ap != null) {
                mElem.setAttribute("description", ap.value());
            }
            if ((typeName = (returnTypeMirror = m.getReturnType()).toString()).contains(this.modelPackage)) {
                typeName = typeName.replace(this.modelPackage + ".", "");
            }
            if (typeName.contains("java.lang.")) {
                typeName = typeName.replaceAll("java\\.lang\\.", "");
            }
            if (typeName.contains("java.util.")) {
                typeName = typeName.replaceAll("java\\.util\\.", "");
            }
            mElem.setAttribute("type", typeName);
        }
    }

    private boolean skipParamType(TypeMirror t) {
        String name = t.toString();
        boolean skip = false;
        for (String toSkip : PARAM_SKIP_ANNOTATIONS) {
            if (!toSkip.equals(name)) continue;
            skip = true;
            break;
        }
        return skip;
    }

    private String getHttpMethod(Collection<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            javax.lang.model.element.Element element = annotationMirror.getAnnotationType().asElement();
            String pName = element.getEnclosingElement().toString();
            String cName = element.getSimpleName().toString();
            if (!pName.startsWith(JAVAX_WS_RS)) continue;
            for (String name : HTTP_METHODS) {
                if (!cName.equals(name)) continue;
                return name;
            }
        }
        return null;
    }

    private void setOptionalAttribute(Element xmlElement, String name, String text) {
        if (text != null && !text.isEmpty()) {
            xmlElement.setAttribute(name, text);
        }
    }

    private void setOptionalAttribute(Element xmlElement, String attributeName, String text, String defaultValue) {
        if (text != null && !text.isEmpty()) {
            xmlElement.setAttribute(attributeName, text);
        } else {
            xmlElement.setAttribute(attributeName, defaultValue);
        }
    }

    private String cleanOutPath(String in) {
        if (in.equals("/")) {
            return "";
        }
        if (in.startsWith("/")) {
            in = in.substring(1);
        }
        if (in.endsWith("/")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }
}

