/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.pluginGen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.helpers.pluginGen.Props;
import org.rhq.helpers.pluginGen.ResourceCategory;

public class PluginGen {
    private final Log log = LogFactory.getLog(PluginGen.class);

    public static void main(String[] arg) throws Exception {
        PluginGen pg = new PluginGen();
        pg.run();
    }

    public void run() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Props props = this.askQuestions(br, new Props());
        if (props == null) {
            return;
        }
        boolean done = false;
        do {
            System.out.println();
            System.out.print("Do you want to add a child to " + props.getName() + "? (y/N) ");
            String answer = br.readLine();
            answer = answer.toLowerCase(Locale.getDefault());
            if (answer.startsWith("n") || answer.length() == 0) {
                done = true;
                continue;
            }
            Props child = this.askQuestions(br, props);
            if (child == null) {
                return;
            }
            props.getChildren().add(child);
        } while (!done);
        this.log.info((Object)("\nYou have choosen:\n" + props.toString()));
        this.postprocess(props);
        this.generate(props);
        System.out.println("Don't forget to ");
        System.out.println("  - add your plugin to the parent pom.xml if needed");
        System.out.println("  - edit pom.xml of your plugin");
        System.out.println("  - edit rhq-plugin.xml of your plugin");
    }

    private void postprocess(Props props) {
        String pkg = props.getPackagePrefix() + "." + props.getName();
        props.setPkg(pkg);
        for (Props cProp : props.getChildren()) {
            cProp.setPkg(pkg);
        }
    }

    private Props askQuestions(BufferedReader br, Props parentProps) throws Exception {
        ResourceCategory cat2;
        Method[] meths = Props.class.getDeclaredMethods();
        Props props = new Props();
        System.out.print("Please specify the plugin root category ");
        List<ResourceCategory> possibleChildren = ResourceCategory.getPossibleChildren(parentProps.getCategory());
        for (ResourceCategory cat2 : possibleChildren) {
            System.out.print((Object)((Object)cat2) + "(" + cat2.getAbbrev() + "), ");
        }
        String answer = br.readLine();
        cat2 = ResourceCategory.getByAbbrv((answer = answer.toUpperCase(Locale.getDefault())).charAt(0));
        if (cat2 != null) {
            props.setCategory(cat2);
        } else {
            System.err.println("Bad answer, only use P/S/I");
            System.exit(1);
        }
        for (Method m : meths) {
            Class<?> retType;
            String name = m.getName();
            if (!name.startsWith("get") && !name.startsWith("is") || !(retType = m.getReturnType()).equals(String.class) && !retType.equals(Boolean.TYPE)) continue;
            if ((name = name.startsWith("get") ? name.substring(3) : name.substring(2)).equals("PackagePrefix") && parentProps.getPackagePrefix() != null) {
                props.setPackagePrefix(parentProps.getPackagePrefix());
                continue;
            }
            if (name.equals("FileSystemRoot") && parentProps.getFileSystemRoot() != null) {
                props.setFileSystemRoot(parentProps.getFileSystemRoot());
                continue;
            }
            if (name.equals("ParentType") && parentProps.getName() != null) {
                props.setParentType(PluginGen.caps(parentProps.getComponentClass()));
                continue;
            }
            if (name.equals("UsesExternalJarsInPlugin") && parentProps.getName() != null || name.equals("UsePluginLifecycleListenerApi") && parentProps.getName() != null || name.equals("DependsOnJmxPlugin") && parentProps.getName() != null || name.equals("RhqVersion") && parentProps.getName() != null || name.equals("Pkg")) continue;
            System.out.print("Please specify");
            boolean isBool = false;
            if (retType.equals(Boolean.TYPE)) {
                System.out.print(" if it should support " + name + " (y/N): ");
                isBool = true;
            } else {
                System.out.print(" its " + name + ": ");
            }
            answer = br.readLine();
            if (answer == null) {
                System.out.println("EOL .. aborting");
                return null;
            }
            String setterName = "set" + PluginGen.caps(name);
            Method setter = isBool ? Props.class.getMethod(setterName, Boolean.TYPE) : Props.class.getMethod(setterName, String.class);
            if (isBool) {
                if (!answer.toLowerCase(Locale.getDefault()).startsWith("y") && !answer.toLowerCase(Locale.getDefault()).startsWith("j")) continue;
                setter.invoke((Object)props, true);
                continue;
            }
            if (answer.startsWith("\n") || answer.startsWith("\r") || answer.length() == 0) continue;
            setter.invoke((Object)props, answer);
        }
        return props;
    }

    private void generate(Props props) {
        boolean success;
        this.log.info((Object)"Generating...");
        if (props.getFileSystemRoot() == null || props.getFileSystemRoot().equals("")) {
            this.log.error((Object)"No root directory given, can not continue");
            return;
        }
        File baseDir = new File(props.getFileSystemRoot());
        if (!baseDir.isDirectory()) {
            this.log.error((Object)("This is no directory: '" + baseDir.getAbsolutePath() + "'"));
            return;
        }
        File activeDirectory = new File(props.getFileSystemRoot(), props.getName());
        if (!activeDirectory.exists() && !(success = activeDirectory.mkdir())) {
            this.log.error((Object)"Creation of plugin basedir failed");
            return;
        }
        this.createFile(props, "pom", "pom.xml", activeDirectory.getAbsolutePath());
        String path = activeDirectory.getAbsolutePath() + File.separator + "src" + File.separator + "main" + File.separator;
        activeDirectory = new File(path);
        if (!activeDirectory.exists() && !(success = activeDirectory.mkdirs())) {
            this.log.error((Object)"Creation of main directory failed");
            return;
        }
        File resourceDirs = new File(path + File.separator + "resources" + File.separator + "META-INF");
        if (!resourceDirs.exists() && !(success = resourceDirs.mkdirs())) {
            this.log.error((Object)"Creation of resources/META-INF failed");
            return;
        }
        this.createFile(props, "descriptor", "rhq-plugin.xml", resourceDirs.getAbsolutePath());
        File javaDirs = new File(path + File.separator + "java" + File.separator + this.toDirPath(props.getPackagePrefix(), File.separator) + props.getName());
        if (!javaDirs.exists() && !(success = javaDirs.mkdirs())) {
            this.log.error((Object)"Creation of java package failed");
            return;
        }
        this.createFile(props, "discovery", props.getDiscoveryClass() + ".java", javaDirs.getAbsolutePath());
        this.createFile(props, "component", props.getComponentClass() + ".java", javaDirs.getAbsolutePath());
        if (props.isEvents()) {
            this.createFile(props, "eventPoller", PluginGen.caps(props.getName()) + "EventPoller.java", javaDirs.getAbsolutePath());
        }
        if (!props.getChildren().isEmpty()) {
            this.log.info((Object)"Creating child services");
        }
        for (Props cProps : props.getChildren()) {
            this.createFile(cProps, "discovery", cProps.getDiscoveryClass() + ".java", javaDirs.getAbsolutePath());
            this.createFile(cProps, "component", cProps.getComponentClass() + ".java", javaDirs.getAbsolutePath());
            if (!cProps.isEvents()) continue;
            this.createFile(cProps, "eventPoller", PluginGen.caps(cProps.getName()) + "EventPoller.java", javaDirs.getAbsolutePath());
        }
        this.log.info((Object)"Done ..");
    }

    private String toDirPath(String pkg, String separator) {
        String res = pkg.replaceAll("\\.", separator);
        if (!pkg.endsWith(".")) {
            res = res + separator;
        }
        return res;
    }

    public void createFile(Props props, String template, String fileName, String directory) {
        try {
            this.log.info((Object)("Trying to generate " + directory + "/" + fileName));
            Configuration config = new Configuration();
            ClassTemplateLoader ctl = new ClassTemplateLoader(this.getClass(), "/");
            TemplateLoader[] loaders = new TemplateLoader[]{ctl};
            MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
            config.setTemplateLoader((TemplateLoader)mtl);
            Template templ = config.getTemplate(template + ".ftl");
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(directory, fileName)));
            HashMap<String, Props> root = new HashMap<String, Props>();
            root.put("props", props);
            templ.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (TemplateException te) {
            te.printStackTrace();
        }
    }

    static String caps(String in) {
        if (in == null) {
            return null;
        }
        return in.substring(0, 1).toUpperCase(Locale.getDefault()) + in.substring(1);
    }
}

