/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.rhq.metrics.embedded.EmbeddedConstants;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigEditor {
    private File configFile;
    private Yaml yaml;
    private Map<String, Object> config;

    public ConfigEditor() {
    }

    public ConfigEditor(File cassandraYamlFile) throws IOException {
        this.configFile = cassandraYamlFile;
        try (FileInputStream inputStream = new FileInputStream(this.configFile);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            this.config = (Map)this.yaml.load((InputStream)inputStream);
        }
    }

    public ConfigEditor(InputStream inputStream, File destFile) throws IOException {
        try (InputStream yamlInputStream = inputStream;){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            this.config = (Map)this.yaml.load(yamlInputStream);
            this.configFile = destFile;
        }
    }

    public void initEmbeddedConfiguration() throws Exception {
        File basedir = new File(System.getProperty("jboss.server.data.dir", "./"), "rhq-metrics");
        File confDir = new File(basedir, "conf");
        File yamlFile = new File(confDir, "cassandra.yaml");
        if (!yamlFile.exists()) {
            File tempFile;
            try (InputStream yamlInputStream = this.getClass().getResourceAsStream("/cassandra.yaml");){
                DumperOptions options = new DumperOptions();
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                this.yaml = new Yaml(options);
                this.config = (Map)this.yaml.load(yamlInputStream);
                this.configFile = yamlFile;
            }
            this.setDataFileDirectories(Arrays.asList(new File(basedir, "data").getAbsolutePath()));
            this.setCommitLogDirectory(new File(basedir, "commitlog").getAbsolutePath());
            this.setSavedCachesDirectory(new File(basedir, "saved_caches").getAbsolutePath());
            this.setClusterName("rhq-metrics");
            this.setSeeds("127.0.0.1");
            this.setListenAddress("127.0.0.1");
            this.setRpcAddress("127.0.0.1");
            this.setNativeTransportPort(EmbeddedConstants.CASSANDRA_NATIVE_PORT_DEFAULT);
            this.setKeyCacheSizeMb(this.getDefaultKeyCacheSize());
            this.setNativeTransportMaxThreads(4);
            this.setCompactionThroughputMbPerSec(0);
            this.setStartRpc(false);
            this.setHintedHandoffEnabled(false);
            this.setNumTokens(1);
            this.setRpcServerType("hsha");
            if (!basedir.exists()) {
                basedir.mkdir();
            }
            if (!confDir.exists()) {
                confDir.mkdir();
            }
            if (!(tempFile = new File(this.getDataFileDirectories().get(0))).exists()) {
                tempFile.mkdirs();
            }
            if (!(tempFile = new File(this.getCommitLogDirectory())).exists()) {
                tempFile.mkdirs();
            }
            if (!(tempFile = new File(this.getSavedCachesDirectory())).exists()) {
                tempFile.mkdirs();
            }
            this.save();
        }
        System.setProperty("cassandra.config", yamlFile.toURI().toURL().toString());
        System.setProperty("cassandra.skip_wait_for_gossip_to_settle", "0");
        System.setProperty("cassandra.start_rpc", "false");
    }

    public void save() throws IOException {
        if (this.configFile != null && this.yaml != null) {
            this.yaml.dump(this.config, (Writer)new FileWriter(this.configFile));
        }
        this.yaml = null;
        this.config = null;
    }

    public String getClusterName() {
        return (String)this.config.get("cluster_name");
    }

    public void setClusterName(String clusterName) {
        this.config.put("cluster_name", clusterName);
    }

    public String getListenAddress() {
        return (String)this.config.get("listen_address");
    }

    public void setListenAddress(String address) {
        this.config.put("listen_address", address);
    }

    public String getRpcAddress() {
        return (String)this.config.get("rpc_address");
    }

    public void setRpcAddress(String address) {
        this.config.put("rpc_address", address);
    }

    public void setRpcServerType(String rpcServerType) {
        this.config.put("rpc_server_type", rpcServerType);
    }

    public String getRpcServerType() {
        return (String)this.config.get("rpc_server_type");
    }

    public String getAuthenticator() {
        return (String)this.config.get("authenticator");
    }

    public String getCommitLogDirectory() {
        return (String)this.config.get("commitlog_directory");
    }

    public void setCommitLogDirectory(String dir) {
        this.config.put("commitlog_directory", dir);
    }

    public List<String> getDataFileDirectories() {
        return (List)this.config.get("data_file_directories");
    }

    public void setDataFileDirectories(List<String> dirs) {
        this.config.put("data_file_directories", dirs);
    }

    public String getSavedCachesDirectory() {
        return (String)this.config.get("saved_caches_directory");
    }

    public void setSavedCachesDirectory(String dir) {
        this.config.put("saved_caches_directory", dir);
    }

    public void setSeeds(String ... seeds) {
        List seedProviderList = (List)this.config.get("seed_provider");
        Map seedProvider = (Map)seedProviderList.get(0);
        List paramsList = (List)seedProvider.get("parameters");
        Map params = (Map)paramsList.get(0);
        StringBuilder seedsString = new StringBuilder();
        for (int i = 0; i < seeds.length; ++i) {
            if (i > 0) {
                seedsString.append(",");
            }
            seedsString.append(seeds[i]);
        }
        params.put("seeds", seedsString.toString());
    }

    public Integer getNativeTransportPort() {
        return (Integer)this.config.get("native_transport_port");
    }

    public void setNativeTransportPort(Integer port) {
        this.config.put("native_transport_port", port);
    }

    public void setCompactionThroughputMbPerSec(Integer compactionThroughput) {
        this.config.put("compaction_throughput_mb_per_sec", compactionThroughput);
    }

    public Integer getCompactionThroughputMbPerSec() {
        return (Integer)this.config.get("compaction_throughput_mb_per_sec");
    }

    public void setKeyCacheSizeMb(Integer keyCacheSizeMb) {
        this.config.put("key_cache_size_in_mb", keyCacheSizeMb);
    }

    public Integer getKeyCacheSizeMb() {
        return (Integer)this.config.get("key_cache_size_in_mb");
    }

    public void setHintedHandoffEnabled(Boolean hintedHandoffEnabled) {
        this.config.put("hinted_handoff_enabled", hintedHandoffEnabled);
    }

    public Boolean isHintedHandoffEnabled() {
        return (Boolean)this.config.get("hinted_handoff_enabled");
    }

    public void setNativeTransportMaxThreads(Integer nativeTransportMaxThreads) {
        this.config.put("native_transport_max_threads", nativeTransportMaxThreads);
    }

    public Integer getNativeTransportMaxThreads() {
        return (Integer)this.config.get("native_transport_max_threads");
    }

    public void setStartRpc(Boolean startRpc) {
        this.config.put("start_rpc", startRpc);
    }

    public boolean getStartRpc() {
        return Boolean.parseBoolean(this.config.get("start_rpc").toString());
    }

    public void setNumTokens(Integer numTokens) {
        this.config.put("num_tokens", numTokens);
    }

    public Integer getNumTokens() {
        return Integer.parseInt(this.config.get("num_tokens").toString());
    }

    private int getDefaultKeyCacheSize() {
        return Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.01 / 1024.0 / 1024.0)), 10);
    }
}

