/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans.syslog;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.metrics.clients.ptrans.SingleMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderUtil {
    private static final Logger logger = LoggerFactory.getLogger(DecoderUtil.class);
    private static Pattern statsDPattern = Pattern.compile("([A-Za-z\\.]+):([0-9\\.]+)\\|[a-z]");

    public static void decodeTheBuffer(ByteBuf data, List<Object> out) {
        if (data.readableBytes() < 1) {
            return;
        }
        String s = data.toString(CharsetUtil.UTF_8).trim();
        Matcher matcher = statsDPattern.matcher(s);
        if (matcher.matches()) {
            String source = matcher.group(1);
            String val = matcher.group(2);
            ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>(1);
            SingleMetric metric = new SingleMetric(source, System.currentTimeMillis(), Double.valueOf(val));
            metrics.add(metric);
            return;
        }
        if (!s.contains("type=metric")) {
            return;
        }
        String text = DecoderUtil.extractPayload(s);
        if (text.contains("type=metric")) {
            text = text.trim();
            long now = System.currentTimeMillis();
            String[] entries = text.split(" ");
            ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>(entries.length);
            String cartName = null;
            if (text.contains("cart=")) {
                int pos = text.indexOf("cart=");
                cartName = text.substring(pos + 5, text.indexOf(32, pos));
            }
            for (String entry : entries) {
                if (entry.equals("type=metric") || entry.startsWith("cart=")) continue;
                String[] keyVal = entry.split("=");
                double value = 0.0;
                try {
                    value = Double.parseDouble(keyVal[1]);
                    String source = keyVal[0];
                    if (cartName != null) {
                        source = cartName + "." + source;
                    }
                    SingleMetric metric = new SingleMetric(source, now, value);
                    metrics.add(metric);
                }
                catch (NumberFormatException e) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.debug("Unknown number format for " + entry + ", skipping");
                }
            }
            out.add(metrics);
        }
    }

    private static String extractPayload(String s) {
        int i = s.indexOf(62) + 1;
        if (s.indexOf(32, i) == i + 3) {
            i = s.indexOf(32, i + 5);
            i = s.indexOf(32, i + 1);
            i = s.indexOf(58, i + 1);
            return s.substring(i + 1);
        }
        i = s.indexOf(32, i + 1);
        i = s.indexOf(58, i) + 1;
        return s.substring(i);
    }
}

