/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans.statsd;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import org.rhq.metrics.client.common.MetricType;
import org.rhq.metrics.client.common.SingleMetric;

public class StatsdDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
        String type;
        String valString;
        ByteBuf buf = (ByteBuf)msg.content();
        if (buf.readableBytes() < 3) {
            buf.clear();
            ctx.close();
            return;
        }
        String packet = buf.toString(CharsetUtil.UTF_8).trim();
        if (!packet.contains(":")) {
            buf.clear();
            ctx.close();
            return;
        }
        String name = packet.substring(0, packet.indexOf(":"));
        String remainder = packet.substring(packet.indexOf(":") + 1);
        if (remainder.contains("|")) {
            valString = remainder.substring(0, remainder.indexOf("|"));
            type = remainder.substring(remainder.indexOf("|") + 1);
        } else {
            valString = remainder;
            type = "";
        }
        Double value = Double.valueOf(valString);
        SingleMetric singleMetric = new SingleMetric(name, System.currentTimeMillis(), value);
        singleMetric.setMetricType(MetricType.from((String)type));
        out.add(singleMetric);
    }
}

