/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import java.net.URI;
import java.util.Properties;
import org.rhq.metrics.clients.ptrans.ConfigurationKey;

public class Configuration {
    private final int udpPort;
    private final int tcpPort;
    private final int gangliaPort;
    private final String gangliaGroup;
    private final int statsDport;
    private final int collectdPort;
    private final String multicastIfOverride;
    private final int minimumBatchSize;
    private final URI restUrl;
    private final int restCloseAfterRequests;
    private final int spoolSize;

    private Configuration(int udpPort, int tcpPort, int gangliaPort, String gangliaGroup, int statsDport, int collectdPort, String multicastIfOverride, int minimumBatchSize, URI restUrl, int restCloseAfterRequests, int spoolSize) {
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
        this.gangliaPort = gangliaPort;
        this.statsDport = statsDport;
        this.collectdPort = collectdPort;
        this.gangliaGroup = gangliaGroup;
        this.multicastIfOverride = multicastIfOverride;
        this.minimumBatchSize = minimumBatchSize;
        this.restUrl = restUrl;
        this.restCloseAfterRequests = restCloseAfterRequests;
        this.spoolSize = spoolSize;
    }

    public static Configuration from(Properties properties) {
        int udpPort = Configuration.getIntProperty(properties, ConfigurationKey.UDP_PORT, 5140);
        int tcpPort = Configuration.getIntProperty(properties, ConfigurationKey.TCP_PORT, 5140);
        int gangliaPort = Configuration.getIntProperty(properties, ConfigurationKey.GANGLIA_PORT, 8649);
        String gangliaGroup = properties.getProperty(ConfigurationKey.GANGLIA_GROUP.getExternalForm(), "239.2.11.71");
        String multicastIfOverride = properties.getProperty(ConfigurationKey.GANGLIA_MULTICAST_INTERFACE.getExternalForm());
        int statsDport = Configuration.getIntProperty(properties, ConfigurationKey.STATSD_PORT, 8125);
        int collectdPort = Configuration.getIntProperty(properties, ConfigurationKey.COLLECTD_PORT, 25826);
        int minimumBatchSize = Configuration.getIntProperty(properties, ConfigurationKey.BATCH_SIZE, 5);
        URI restUrl = URI.create(properties.getProperty(ConfigurationKey.REST_URL.getExternalForm(), "http://localhost:8080/rhq-metrics/metrics"));
        int restCloseAfterRequests = Configuration.getIntProperty(properties, ConfigurationKey.REST_CLOSE_AFTER_REQUESTS, 200);
        int spoolSize = Configuration.getIntProperty(properties, ConfigurationKey.SPOOL_SIZE, 10000);
        return new Configuration(udpPort, tcpPort, gangliaPort, gangliaGroup, statsDport, collectdPort, multicastIfOverride, minimumBatchSize, restUrl, restCloseAfterRequests, spoolSize);
    }

    private static int getIntProperty(Properties properties, ConfigurationKey key, int defaultValue) {
        String property = properties.getProperty(key.getExternalForm());
        if (property == null) {
            return defaultValue;
        }
        return Integer.parseInt(property);
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getGangliaPort() {
        return this.gangliaPort;
    }

    public int getStatsDport() {
        return this.statsDport;
    }

    public int getCollectdPort() {
        return this.collectdPort;
    }

    public String getGangliaGroup() {
        return this.gangliaGroup;
    }

    public String getMulticastIfOverride() {
        return this.multicastIfOverride;
    }

    public int getMinimumBatchSize() {
        return this.minimumBatchSize;
    }

    public URI getRestUrl() {
        return this.restUrl;
    }

    public int getRestCloseAfterRequests() {
        return this.restCloseAfterRequests;
    }

    public int getSpoolSize() {
        return this.spoolSize;
    }
}

