/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import jnr.posix.POSIXFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.rhq.metrics.clients.ptrans.Configuration;
import org.rhq.metrics.clients.ptrans.OptionsFactory;
import org.rhq.metrics.clients.ptrans.PTrans;
import org.rhq.metrics.clients.ptrans.PidFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private final String[] args;
    private final OptionsFactory optionsFactory;
    private PTrans ptrans;
    private PidFile pidFile;

    private Main(String[] args) {
        this.args = args;
        this.optionsFactory = new OptionsFactory();
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private void start() throws Exception {
        File configFile;
        Options options = this.optionsFactory.getCommandOptions(true);
        Exception parseException = null;
        CommandLine cmd = null;
        try {
            PosixParser parser = new PosixParser();
            cmd = parser.parse(options, this.args, true);
        }
        catch (Exception e) {
            parseException = e;
        }
        boolean hasHelpOption = this.hasHelpOption();
        if (parseException != null) {
            if (!hasHelpOption) {
                System.err.println(parseException.getMessage());
            }
            this.printHelp();
            System.exit(hasHelpOption ? 0 : 1);
        }
        if (hasHelpOption) {
            this.printHelp();
            System.exit(0);
        }
        if (!(configFile = new File(cmd.getOptionValue("c"))).isFile()) {
            System.err.printf("Configuration file %s does not exist or is not readable.%n", configFile.getAbsolutePath());
            System.exit(1);
        }
        if (cmd.hasOption("p")) {
            File file = new File(cmd.getOptionValue("p"));
            this.pidFile = new PidFile(file);
            boolean locked = this.pidFile.tryLock(POSIXFactory.getPOSIX().getpid());
            if (!locked) {
                System.exit(1);
            }
        }
        Properties properties = this.loadConfigurationProperties(configFile);
        this.ptrans = new PTrans(Configuration.from(properties));
        this.ptrans.start();
    }

    private boolean hasHelpOption() {
        Options commandOptions = this.optionsFactory.getCommandOptions(false);
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(commandOptions, this.args, true);
            return cmd.hasOption("h");
        }
        catch (Exception e) {
            return false;
        }
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(Integer.MAX_VALUE);
        formatter.printHelp("ptrans", this.optionsFactory.getCommandOptions(true), true);
    }

    private void stop() {
        try {
            if (this.ptrans != null) {
                this.ptrans.stop();
            }
        }
        finally {
            if (this.pidFile != null) {
                this.pidFile.release();
            }
        }
    }

    private Properties loadConfigurationProperties(File configFile) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            properties.load(inputStream);
        }
        return properties;
    }

    public static void main(String[] args) {
        Main main = new Main(args);
        try {
            main.start();
        }
        catch (Exception e) {
            LOG.error("Exception on startup", (Throwable)e);
            System.exit(1);
        }
    }
}

