/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.rhq.metrics.clients.ptrans.Configuration;
import org.rhq.metrics.clients.ptrans.DemuxHandler;
import org.rhq.metrics.clients.ptrans.MetricBatcher;
import org.rhq.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.rhq.metrics.clients.ptrans.collectd.CollectdEventHandler;
import org.rhq.metrics.clients.ptrans.ganglia.UdpGangliaDecoder;
import org.rhq.metrics.clients.ptrans.statsd.StatsdDecoder;
import org.rhq.metrics.clients.ptrans.syslog.UdpSyslogEventDecoder;
import org.rhq.metrics.netty.collectd.event.CollectdEventsDecoder;
import org.rhq.metrics.netty.collectd.packet.CollectdPacketDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTrans {
    private static final Logger LOG = LoggerFactory.getLogger(PTrans.class);
    private final Configuration configuration;
    private final EventLoopGroup group;
    private final EventLoopGroup workerGroup;

    public PTrans(Configuration configuration) {
        this.configuration = configuration;
        this.group = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
    }

    public void start() throws Exception {
        final RestForwardingHandler forwardingHandler = new RestForwardingHandler(this.configuration);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.group, this.workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.configuration.getTcpPort())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new DemuxHandler(PTrans.this.configuration, forwardingHandler)});
            }
        });
        ChannelFuture graphiteFuture = serverBootstrap.bind().sync();
        LOG.info("Server listening on TCP " + graphiteFuture.channel().localAddress());
        graphiteFuture.channel().closeFuture();
        Bootstrap udpBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getUdpPort())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new UdpSyslogEventDecoder()});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        ChannelFuture udpFuture = udpBootstrap.bind().sync();
        LOG.info("Syslogd listening on udp " + udpFuture.channel().localAddress());
        this.setupGangliaUdp(this.group, forwardingHandler);
        this.setupStatsdUdp(this.group, forwardingHandler);
        this.setupCollectdUdp(this.group, forwardingHandler);
        udpFuture.channel().closeFuture().sync();
    }

    private void setupCollectdUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter forwardingHandler) {
        Bootstrap collectdBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)collectdBootstrap.group(group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getCollectdPort())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new CollectdPacketDecoder()});
                pipeline.addLast(new ChannelHandler[]{new CollectdEventsDecoder()});
                pipeline.addLast(new ChannelHandler[]{new CollectdEventHandler()});
                pipeline.addLast(new ChannelHandler[]{new MetricBatcher("collectd", PTrans.this.configuration.getMinimumBatchSize())});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        try {
            ChannelFuture collectdFuture = collectdBootstrap.bind().sync();
            LOG.info("Collectd listening on udp " + collectdFuture.channel().localAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupStatsdUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter forwardingHandler) {
        Bootstrap statsdBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)statsdBootstrap.group(group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getStatsDport())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new StatsdDecoder()});
                pipeline.addLast(new ChannelHandler[]{new MetricBatcher("statsd", PTrans.this.configuration.getMinimumBatchSize())});
                pipeline.addLast(new ChannelHandler[]{forwardingHandler});
            }
        });
        try {
            ChannelFuture statsdFuture = statsdBootstrap.bind().sync();
            LOG.info("Statsd listening on udp " + statsdFuture.channel().localAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupGangliaUdp(EventLoopGroup group, final ChannelInboundHandlerAdapter fowardingHandler) {
        try {
            NetworkInterface mcIf;
            String multicastIfOverride = this.configuration.getMulticastIfOverride();
            if (multicastIfOverride == null) {
                Inet4Address hostAddr = (Inet4Address)InetAddress.getLocalHost();
                mcIf = NetworkInterface.getByInetAddress(hostAddr);
            } else {
                mcIf = NetworkInterface.getByName(multicastIfOverride);
            }
            InetSocketAddress gangliaSocket = new InetSocketAddress(this.configuration.getGangliaGroup(), this.configuration.getGangliaPort());
            Bootstrap gangliaBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)gangliaBootstrap.group(group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.IP_MULTICAST_IF, (Object)mcIf)).localAddress((SocketAddress)gangliaSocket)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new UdpGangliaDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new MetricBatcher("ganglia", PTrans.this.configuration.getMinimumBatchSize())});
                    pipeline.addLast(new ChannelHandler[]{fowardingHandler});
                }
            });
            LOG.info("Bootstrap is " + gangliaBootstrap);
            ChannelFuture gangliaFuture = gangliaBootstrap.bind().sync();
            LOG.info("Ganglia listening on udp " + gangliaFuture.channel().localAddress());
            DatagramChannel channel = (DatagramChannel)gangliaFuture.channel();
            channel.joinGroup(gangliaSocket, mcIf).sync();
            LOG.info("Joined the group");
            channel.closeFuture();
        }
        catch (InterruptedException | SocketException | UnknownHostException e) {
            LOG.warn("Setup of udp multicast for Ganglia failed");
            e.printStackTrace();
        }
    }

    public void stop() {
        LOG.info("Stopping ptrans...");
        Future groupShutdownFuture = this.group.shutdownGracefully();
        Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully();
        try {
            groupShutdownFuture.sync();
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        try {
            workerGroupShutdownFuture.sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOG.info("Stopped");
    }
}

