/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;

class PidFile {
    private final File file;
    private FileChannel channel;
    private FileLock fileLock;

    PidFile(File file) {
        this.file = file;
    }

    boolean tryLock(int pid) {
        try {
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            System.err.printf("Unable to open PID file %s for writing.%n", this.file.getAbsolutePath());
            return false;
        }
        try {
            this.fileLock = this.channel.tryLock();
        }
        catch (IOException e) {
            System.err.printf("Unable to lock PID file %s.%n", this.file.getAbsolutePath());
            return false;
        }
        if (this.fileLock == null) {
            System.err.printf("Unable to lock PID file %s, another instance is probably running.%n", this.file.getAbsolutePath());
            return false;
        }
        try {
            this.channel.truncate(0L);
        }
        catch (IOException e) {
            System.err.printf("Unable to truncate PID file %s.%n", this.file.getAbsolutePath());
            return false;
        }
        byte[] bytes = String.format("%d%n", pid).getBytes(StandardCharsets.US_ASCII);
        try {
            this.channel.write(ByteBuffer.wrap(bytes));
        }
        catch (IOException e) {
            System.err.printf("Unable to write to PID file %s.%n", this.file.getAbsolutePath());
            return false;
        }
        this.file.deleteOnExit();
        return true;
    }

    void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

