/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.restServlet.ServiceKeeper;

@ApplicationScoped
public class MetricsServiceProducer {
    @Inject
    private ServletContext context;
    private MetricsService metricsService;

    @Produces
    public MetricsService getMetricsService() {
        if (this.metricsService == null) {
            try {
                String className = null;
                String backend = System.getProperty("rhq-metrics.backend");
                if (backend != null) {
                    switch (backend) {
                        case "mem": {
                            className = "org.rhq.metrics.impl.memory.MemoryMetricsService";
                            break;
                        }
                        case "cass": {
                            className = "org.rhq.metrics.impl.cassandra.MetricsServiceCassandra";
                        }
                    }
                }
                if (className == null) {
                    className = this.context.getInitParameter("rhq-metrics.backend");
                }
                Class<?> clazz = Class.forName(className);
                this.metricsService = (MetricsService)clazz.newInstance();
                this.metricsService.startUp(Collections.emptyMap());
                ServiceKeeper.getInstance().service = this.metricsService;
                return this.metricsService;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Cannot create MetricsService class", e);
            }
        }
        return this.metricsService;
    }
}

