/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.RawNumericMetric;
import org.rhq.metrics.restServlet.InfluxHandler;
import org.rhq.metrics.restServlet.ServiceKeeper;
import org.rhq.metrics.restServlet.StringValue;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/influx")
@Produces(value={"application/json"})
public class InfluxHandler {
    private static final String SELECT_FROM = "select ";
    static Pattern metricSelectPattern = Pattern.compile("select +(\\S+) +as +(\\S+) +from +(\\S+) +where +(.*?) +group by time\\((\\S+)\\).*");
    static Pattern timePattern = Pattern.compile("([0-9]+)([a-z])");
    @Inject
    private MetricsService metricsService;

    @GET
    @Path(value="/series")
    public void series(@Suspended AsyncResponse asyncResponse, @QueryParam(value="q") String queryString) {
        if (queryString.equals("list series")) {
            List names = ServiceKeeper.getInstance().service.listMetrics();
            ArrayList<InfluxObject> objects = new ArrayList<InfluxObject>(names.size() + 2);
            for (String name : names) {
                InfluxObject obj = new InfluxObject(this, name, null);
                obj.columns = new ArrayList(2);
                obj.columns.add("time");
                obj.columns.add("sequence_number");
                obj.columns.add("val");
                obj.points = new ArrayList(1);
                objects.add(obj);
            }
            InfluxObject obj = new InfluxObject(this, "bla", null);
            obj.columns = new ArrayList(2);
            obj.columns.add("time");
            obj.columns.add("sequence_number");
            obj.points = new ArrayList(1);
            objects.add(obj);
            Response.ResponseBuilder builder = Response.ok(objects);
            asyncResponse.resume((Object)builder.build());
        } else {
            String query = queryString.toLowerCase();
            if (query.startsWith("select ")) {
                InfluxQuery iq = new InfluxQuery(this, query, null);
                Long start = InfluxQuery.access$200((InfluxQuery)iq);
                Long end = InfluxQuery.access$300((InfluxQuery)iq);
                String metric = InfluxQuery.access$400((InfluxQuery)iq);
                String alias = InfluxQuery.access$500((InfluxQuery)iq);
                ListenableFuture future = this.metricsService.findData(metric, start.longValue(), end.longValue());
                Long finalStart = start;
                Long finalEnd = end;
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                StringValue errMsg = new StringValue("Query not yet supported: " + queryString);
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            }
        }
    }

    private List<RawNumericMetric> applyMapping(String mapping, List<RawNumericMetric> in, int bucketLengthSec, long startTime, long endTime) {
        if (mapping == null || mapping.isEmpty() || mapping.equals("none")) {
            return in;
        }
        long timeDiff = endTime - startTime;
        int numBuckets = (int)(timeDiff / 1000L / (long)bucketLengthSec);
        HashMap<Integer, ArrayList<RawNumericMetric>> tmpMap = new HashMap<Integer, ArrayList<RawNumericMetric>>(numBuckets);
        for (RawNumericMetric rnm : in) {
            int pos = (int)((rnm.getTimestamp() - startTime) / 1000L) / bucketLengthSec;
            ArrayList<RawNumericMetric> bucket = (ArrayList<RawNumericMetric>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<RawNumericMetric>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(rnm);
        }
        ArrayList<RawNumericMetric> out = new ArrayList<RawNumericMetric>(numBuckets);
        TreeSet keySet = new TreeSet(tmpMap.keySet());
        for (Integer pos : keySet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            if (list == null) continue;
            switch (mapping) {
                case "mean": {
                    for (RawNumericMetric rnm : list) {
                        retVal += rnm.getAvg().doubleValue();
                    }
                    retVal /= (double)list.size();
                    break;
                }
                case "max": {
                    retVal = Double.MIN_VALUE;
                    for (RawNumericMetric rnm : list) {
                        if (!(rnm.getAvg() > retVal)) continue;
                        retVal = rnm.getAvg();
                    }
                    break;
                }
                case "min": {
                    retVal = Double.MAX_VALUE;
                    for (RawNumericMetric rnm : list) {
                        if (!(rnm.getAvg() < retVal)) continue;
                        retVal = rnm.getAvg();
                    }
                    break;
                }
                case "sum": {
                    for (RawNumericMetric rnm : list) {
                        retVal += rnm.getAvg().doubleValue();
                    }
                    break;
                }
                case "count": {
                    retVal = list.size();
                    break;
                }
                case "first": {
                    if (list.isEmpty()) break;
                    retVal = ((RawNumericMetric)list.get(0)).getAvg();
                    break;
                }
                case "last": {
                    if (list.isEmpty()) break;
                    retVal = ((RawNumericMetric)list.get(list.size() - 1)).getAvg();
                    break;
                }
                case "difference": {
                    if (list.isEmpty()) break;
                    retVal = ((RawNumericMetric)list.get(list.size() - 1)).getAvg() - ((RawNumericMetric)list.get(0)).getAvg();
                    break;
                }
                default: {
                    System.out.println("Mapping of " + mapping + " not yet supported");
                }
            }
            RawNumericMetric outMetric = new RawNumericMetric(((RawNumericMetric)list.get(0)).getId(), Double.valueOf(retVal), ((RawNumericMetric)list.get(0)).getTimestamp());
            out.add(outMetric);
        }
        return out;
    }

    private String deQuote(String in) {
        if (in == null) {
            return null;
        }
        int start = 0;
        int end = in.length();
        if (in.startsWith("\"")) {
            ++start;
        }
        if (in.endsWith("\"")) {
            --end;
        }
        String out = in.substring(start, end);
        return out;
    }

    static /* synthetic */ List access$800(InfluxHandler x0, String x1, List x2, int x3, long x4, long x5) {
        return x0.applyMapping(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ String access$900(InfluxHandler x0, String x1) {
        return x0.deQuote(x1);
    }
}

