/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.metrics.core.Counter;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.NumericMetric;
import org.rhq.metrics.core.RawNumericMetric;
import org.rhq.metrics.restServlet.BucketDataPoint;
import org.rhq.metrics.restServlet.IdDataPoint;
import org.rhq.metrics.restServlet.MetricHandler;
import org.rhq.metrics.restServlet.ServiceKeeper;
import org.rhq.metrics.restServlet.SimpleLink;
import org.rhq.metrics.restServlet.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Related to metrics")
@Path(value="/")
public class MetricHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetricHandler.class);
    private static final long EIGHT_HOURS = 28800000L;
    @Inject
    private MetricsService metricsService;

    public MetricHandler() {
        if (logger.isDebugEnabled()) {
            logger.debug("MetricHandler instantiated");
        }
    }

    @GET
    @POST
    @Path(value="/ping")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    @ApiOperation(value="Returns the current time and serves to check for the availability of the api.", responseClass="Map<String,String>")
    public Response ping() {
        StringValue reply = new StringValue(new Date().toString());
        Response.ResponseBuilder builder = Response.ok((Object)reply);
        return builder.build();
    }

    @POST
    @Path(value="/metrics/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Adds a single data point for the given id.")
    public void addMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, IdDataPoint dataPoint) {
        this.addData(asyncResponse, (Set)ImmutableSet.of((Object)new RawNumericMetric(id, Double.valueOf(dataPoint.getValue()), dataPoint.getTimestamp())));
    }

    @POST
    @Path(value="/metrics")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Add a collection of data. Values can be for different metric ids.")
    public void addMetrics(@Suspended AsyncResponse asyncResponse, Collection<IdDataPoint> dataPoints) {
        HashSet<RawNumericMetric> rawSet = new HashSet<RawNumericMetric>(dataPoints.size());
        for (IdDataPoint dataPoint : dataPoints) {
            RawNumericMetric rawMetric = new RawNumericMetric(dataPoint.getId(), Double.valueOf(dataPoint.getValue()), dataPoint.getTimestamp());
            rawSet.add(rawMetric);
        }
        this.addData(asyncResponse, rawSet);
    }

    private void addData(AsyncResponse asyncResponse, Set<RawNumericMetric> rawData) {
        ListenableFuture future = this.metricsService.addData(rawData);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters")
    @Produces(value={"application/json"})
    public void updateCountersForGroups(@Suspended AsyncResponse asyncResponse, Collection<Counter> counters) {
        this.updateCounters(asyncResponse, counters);
    }

    @POST
    @Path(value="/counters/{group}")
    @Produces(value={"application/json"})
    public void updateCounterForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, Collection<Counter> counters) {
        for (Counter counter : counters) {
            counter.setGroup(group);
        }
        this.updateCounters(asyncResponse, counters);
    }

    private void updateCounters(AsyncResponse asyncResponse, Collection<Counter> counters) {
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters/{group}/{counter}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        this.updateCounterValue(asyncResponse, group, counter, Long.valueOf(1L));
    }

    @POST
    @Path(value="/counters/{group}/{counter}/{value}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter, @PathParam(value="value") Long value) {
        this.updateCounterValue(asyncResponse, group, counter, value);
    }

    private void updateCounterValue(AsyncResponse asyncResponse, String group, String counter, Long value) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter(group, counter, value.longValue()));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCountersForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group) {
        ListenableFuture future = this.metricsService.findCounters(group);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}/{counter}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.findCounters(group, Arrays.asList(counter));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GZIP
    @GET
    @Path(value="/metrics/{id}")
    @ApiOperation(value="Return metrical values for a given metric id. If no parameters are given, the raw data for a time period of [now-8h,now] is returned.")
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    public void getDataForId(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Id of the metric to return data for") @PathParam(value="id") String id, @ApiParam(value="Start time in millis since epoch", defaultValue="Now - 8h") @QueryParam(value="start") Long start, @ApiParam(value="End time in millis since epoch", defaultValue="Now") @QueryParam(value="end") Long end, @ApiParam(value="If non-zero: number of buckets to partition the data into. Raw data otherwise", defaultValue="0") @QueryParam(value="buckets") int numberOfBuckets, @QueryParam(value="bucketWidthSeconds") int bucketWidthSeconds, @ApiParam(value="If true, empty buckets are not returned.") @QueryParam(value="skipEmpty") @DefaultValue(value="false") boolean skipEmpty, @QueryParam(value="bucketCluster") @DefaultValue(value="true") boolean bucketCluster, @Context HttpHeaders headers) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - 28800000L;
        }
        if (end == null) {
            end = now;
        }
        ListenableFuture future = this.metricsService.findData(id, start.longValue(), end.longValue());
        Long finalStart = start;
        Long finalEnd = end;
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GZIP
    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    public Response listMetrics(@QueryParam(value="q") String filter) {
        List names = ServiceKeeper.getInstance().service.listMetrics();
        ArrayList<SimpleLink> listWithLinks = new ArrayList<SimpleLink>(names.size());
        for (String name : names) {
            if (filter != null && !filter.isEmpty() && !name.contains(filter)) continue;
            SimpleLink link = new SimpleLink("metrics", "/rhq-metrics/metrics/" + name + "/", name);
            listWithLinks.add(link);
        }
        7 list = new /* Unavailable Anonymous Inner Class!! */;
        Response.ResponseBuilder builder = Response.ok((Object)list);
        return builder.build();
    }

    private BucketDataPoint createPointInSimpleBucket(String id, long startTime, long bucketsize, List<RawNumericMetric> metrics) {
        ArrayList<RawNumericMetric> bucketMetrics = new ArrayList<RawNumericMetric>(metrics.size());
        for (NumericMetric numericMetric : metrics) {
            if (numericMetric.getTimestamp() < startTime || numericMetric.getTimestamp() >= startTime + bucketsize) continue;
            bucketMetrics.add((RawNumericMetric)numericMetric);
        }
        return this.getBucketDataPoint(id, startTime, bucketMetrics);
    }

    private BucketDataPoint getBucketDataPoint(String id, long startTime, List<RawNumericMetric> bucketMetrics) {
        double avg;
        Double min = null;
        Double max = null;
        double sum = 0.0;
        for (RawNumericMetric raw : bucketMetrics) {
            if (max == null || raw.getValue() > max) {
                max = raw.getValue();
            }
            if (min == null || raw.getValue() < min) {
                min = raw.getValue();
            }
            sum += raw.getValue().doubleValue();
        }
        double d = avg = bucketMetrics.size() > 0 ? sum / (double)bucketMetrics.size() : Double.NaN;
        if (min == null) {
            min = Double.NaN;
        }
        if (max == null) {
            max = Double.NaN;
        }
        BucketDataPoint result = new BucketDataPoint(id, startTime, min.doubleValue(), avg, max.doubleValue());
        return result;
    }

    static /* synthetic */ BucketDataPoint access$000(MetricHandler x0, String x1, long x2, long x3, List x4) {
        return x0.createPointInSimpleBucket(x1, x2, x3, x4);
    }

    static /* synthetic */ BucketDataPoint access$100(MetricHandler x0, String x1, long x2, List x3) {
        return x0.getBucketDataPoint(x1, x2, x3);
    }
}

