/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class InfluxTimeParser {
    public static final Pattern simpleTimePattern = Pattern.compile("([0-9]+)([a-z])");

    public static long getTimeFromExpr(Matcher m) {
        long factor;
        String unit;
        String val = m.group(1);
        switch (unit = m.group(2)) {
            case "w": {
                factor = 604800000L;
                break;
            }
            case "d": {
                factor = 86400000L;
                break;
            }
            case "h": {
                factor = 3600000L;
                break;
            }
            case "m": {
                factor = 60000L;
                break;
            }
            case "s": {
                factor = 1000L;
                break;
            }
            case "u": {
                factor = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown unit " + unit);
            }
        }
        long offset = Long.parseLong(val);
        return offset * factor;
    }

    public static long parseTime(String timeExpr) {
        String tmp;
        if (timeExpr.startsWith("time")) {
            tmp = timeExpr.substring(4);
            if (tmp.indexOf(62) > -1) {
                tmp = tmp.substring(tmp.indexOf(62) + 1);
            } else if (tmp.indexOf(60) > -1) {
                tmp = tmp.substring(tmp.indexOf(60) + 1);
            }
            tmp = tmp.trim();
        } else {
            tmp = timeExpr;
        }
        if (tmp.startsWith("now()")) {
            tmp = tmp.substring(5);
            tmp = tmp.substring(tmp.indexOf("-") + 1);
            Matcher m = simpleTimePattern.matcher(tmp = tmp.trim());
            if (m.matches()) {
                long convertedOffset = InfluxTimeParser.getTimeFromExpr((Matcher)m);
                return System.currentTimeMillis() - convertedOffset;
            }
        } else {
            Matcher m = simpleTimePattern.matcher(tmp);
            if (m.matches()) {
                return InfluxTimeParser.getTimeFromExpr((Matcher)m);
            }
            try {
                Date date;
                if (tmp.startsWith("'")) {
                    tmp = tmp.substring(1);
                }
                if (tmp.endsWith("'")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                if ((tmp = tmp.trim()).contains(".")) {
                    SimpleDateFormat dateFormatLong = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
                    date = dateFormatLong.parse(tmp);
                } else if (tmp.contains(":")) {
                    SimpleDateFormat dateFormatMedium = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    date = dateFormatMedium.parse(tmp);
                } else {
                    SimpleDateFormat dateFormatShort = new SimpleDateFormat("yyyy-MM-dd");
                    date = dateFormatShort.parse(tmp);
                }
                return date.getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }
}

