/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletResponse;
import org.rhq.metrics.restServlet.JsonPFilter;

public class JsonPAsyncListener
implements AsyncListener {
    private HttpServletResponse origResponse;
    private String callback;

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        JsonPFilter.JsonPResponseWrapper responseWrapper = (JsonPFilter.JsonPResponseWrapper)asyncEvent.getSuppliedResponse();
        Object responseOutputStream = this.origResponse.getOutputStream();
        boolean gzipped = responseWrapper.getHeader("Content-Encoding").equalsIgnoreCase("gzip");
        if (gzipped) {
            responseOutputStream = new GZIPOutputStream((OutputStream)responseOutputStream);
        }
        this.origResponse.setContentType("application/javascript; charset=utf-8");
        ((OutputStream)responseOutputStream).write((this.callback + "(").getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream jsonpOutputStream = responseWrapper.getByteArrayOutputStream();
        if (gzipped) {
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(jsonpOutputStream.toByteArray()));){
                String read;
                InputStreamReader reader = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);
                BufferedReader in = new BufferedReader(reader);
                while ((read = in.readLine()) != null) {
                    ((OutputStream)responseOutputStream).write(read.getBytes(StandardCharsets.UTF_8));
                }
            }
        } else {
            jsonpOutputStream.writeTo((OutputStream)responseOutputStream);
        }
        ((OutputStream)responseOutputStream).write(");".getBytes(StandardCharsets.UTF_8));
        ((OutputStream)responseOutputStream).flush();
        if (gzipped) {
            ((GZIPOutputStream)responseOutputStream).finish();
        }
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    public void set(HttpServletResponse httpResponse, String callback) {
        this.origResponse = httpResponse;
        this.callback = callback;
    }
}

