/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.Tenant;
import org.rhq.metrics.restServlet.TenantParams;

@Path(value="/tenants")
public class TenantsHandler {
    @Inject
    private MetricsService metricsService;

    @POST
    @Consumes(value={"application/json"})
    public void createTenant(@Suspended AsyncResponse asyncResponse, TenantParams params) {
        Tenant tenant = new Tenant().setId(params.getId());
        for (String type : params.getRetentions().keySet()) {
            if (type.equals(MetricType.NUMERIC.getText())) {
                tenant.setRetention(MetricType.NUMERIC, ((Integer)params.getRetentions().get(type)).intValue());
                continue;
            }
            if (type.equals(MetricType.AVAILABILITY.getText())) {
                tenant.setRetention(MetricType.AVAILABILITY, ((Integer)params.getRetentions().get(type)).intValue());
                continue;
            }
            ImmutableMap errors = ImmutableMap.of((Object)"errorMessage", (Object)("The retentions property is invalid. [" + type + "] is not a recognized metric type"));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
        ListenableFuture insertFuture = this.metricsService.createTenant(tenant);
        Futures.addCallback((ListenableFuture)insertFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Consumes(value={"application/json"})
    public void findTenants(@Suspended AsyncResponse response) {
        ListenableFuture tenantsFuture = this.metricsService.getTenants();
        Futures.addCallback((ListenableFuture)tenantsFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

