/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx.query.translate;

import javax.enterprise.context.ApplicationScoped;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.rhq.metrics.restServlet.influx.query.parse.definition.AndBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.BooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.GtBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.InstantOperand;
import org.rhq.metrics.restServlet.influx.query.parse.definition.LtBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.Operand;
import org.rhq.metrics.restServlet.influx.query.parse.definition.OperandUtils;

@ApplicationScoped
public class ToIntervalTranslator {
    public Interval toInterval(BooleanExpression whereClause) {
        if (whereClause instanceof GtBooleanExpression) {
            return this.getIntervalFromGtExpression((GtBooleanExpression)whereClause);
        }
        if (whereClause instanceof LtBooleanExpression) {
            return this.getIntervalFromLtExpression((LtBooleanExpression)whereClause);
        }
        AndBooleanExpression and = (AndBooleanExpression)whereClause;
        Interval left = and.getLeftExpression() instanceof GtBooleanExpression ? this.getIntervalFromGtExpression((GtBooleanExpression)and.getLeftExpression()) : this.getIntervalFromLtExpression((LtBooleanExpression)and.getLeftExpression());
        Interval right = and.getRightExpression() instanceof GtBooleanExpression ? this.getIntervalFromGtExpression((GtBooleanExpression)and.getRightExpression()) : this.getIntervalFromLtExpression((LtBooleanExpression)and.getRightExpression());
        return left.overlap((ReadableInterval)right);
    }

    private Interval getIntervalFromLtExpression(LtBooleanExpression whereClause) {
        LtBooleanExpression lt = whereClause;
        if (OperandUtils.isTimeOperand((Operand)lt.getLeftOperand())) {
            InstantOperand instantOperand = (InstantOperand)lt.getRightOperand();
            return new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)instantOperand.getInstant());
        }
        InstantOperand instantOperand = (InstantOperand)lt.getLeftOperand();
        return new Interval((ReadableInstant)instantOperand.getInstant(), (ReadableInstant)Instant.now());
    }

    private Interval getIntervalFromGtExpression(GtBooleanExpression gt) {
        if (OperandUtils.isTimeOperand((Operand)gt.getLeftOperand())) {
            InstantOperand instantOperand = (InstantOperand)gt.getRightOperand();
            return new Interval((ReadableInstant)instantOperand.getInstant(), (ReadableInstant)Instant.now());
        }
        InstantOperand instantOperand = (InstantOperand)gt.getLeftOperand();
        return new Interval((ReadableInstant)new Instant(0L), (ReadableInstant)instantOperand.getInstant());
    }
}

