/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.rhq.metrics.RHQMetrics;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.restServlet.Eager;
import org.rhq.metrics.restServlet.config.Configurable;
import org.rhq.metrics.restServlet.config.ConfigurationKey;
import org.rhq.metrics.restServlet.config.ConfigurationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Eager
public class MetricsServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceProducer.class);
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.BACKEND)
    private String backend;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    private MetricsService metricsService;

    @PostConstruct
    void init() {
        LOG.info("Initializing metrics service");
        this.getMetricsService();
    }

    @Produces
    public MetricsService getMetricsService() {
        if (this.metricsService == null) {
            RHQMetrics.Builder metricsServiceBuilder = new RHQMetrics.Builder();
            if (this.backend != null) {
                switch (this.backend) {
                    case "cass": {
                        LOG.info("Using Cassandra backend implementation");
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("cqlport", this.cqlPort);
                        options.put("nodes", this.nodes);
                        options.put("keyspace", this.keyspace);
                        metricsServiceBuilder.withOptions(options).withCassandraDataStore();
                        break;
                    }
                    case "mem": {
                        throw new RuntimeException("The memory backend is no longer supported");
                    }
                    default: {
                        LOG.info("Using Cassandra backend implementation with an embedded Server");
                        metricsServiceBuilder.withCassandraDataStore();
                        break;
                    }
                }
            } else {
                metricsServiceBuilder.withCassandraDataStore();
            }
            this.metricsService = metricsServiceBuilder.build();
        }
        return this.metricsService;
    }
}

