/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Objects;
import java.util.Set;

public class NumericDataPoint {
    private long timestamp;
    private double value;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> tags;

    public NumericDataPoint() {
    }

    public NumericDataPoint(long timestamp, double value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericDataPoint that = (NumericDataPoint)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", this.value).add("tags", (Object)this.tags).toString();
    }
}

