/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx.query.validation;

import org.rhq.metrics.restServlet.influx.query.parse.definition.AggregatedColumnDefinition;
import org.rhq.metrics.restServlet.influx.query.parse.definition.ColumnDefinition;
import org.rhq.metrics.restServlet.influx.query.parse.definition.SelectQueryDefinitions;
import org.rhq.metrics.restServlet.influx.query.validation.AggregationFunction;
import org.rhq.metrics.restServlet.influx.query.validation.IllegalQueryException;
import org.rhq.metrics.restServlet.influx.query.validation.QueryNotSupportedException;
import org.rhq.metrics.restServlet.influx.query.validation.SelectQueryValidationRule;

public class AggregatorsRule
implements SelectQueryValidationRule {
    public void checkQuery(SelectQueryDefinitions queryDefinitions) throws IllegalQueryException {
        if (queryDefinitions.isStarColumn()) {
            return;
        }
        for (ColumnDefinition columnDefinition : queryDefinitions.getColumnDefinitions()) {
            if (!(columnDefinition instanceof AggregatedColumnDefinition)) continue;
            AggregatedColumnDefinition definition = (AggregatedColumnDefinition)columnDefinition;
            this.checkAggregatedColumnDefinition(definition);
        }
    }

    private void checkAggregatedColumnDefinition(AggregatedColumnDefinition definition) throws IllegalQueryException {
        AggregationFunction function = AggregationFunction.findByName((String)definition.getAggregationFunction());
        if (function == null) {
            throw new QueryNotSupportedException("Aggregation function: " + definition.getAggregationFunction());
        }
        function.getValidationRule().checkArguments(definition.getAggregationFunctionArguments());
    }
}

