/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.jsonp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/javascript"})
@ConstrainedTo(value=RuntimeType.SERVER)
public class JsonPProvider
implements MessageBodyWriter<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPProvider.class);
    private static final String CALLBACK_PARAM_CONFIG = "org.rhq.metrics.restServlet.jsonp.JsonPProvider";
    private static final String CALLBACK_PARAM_DEFAULT = "jsonp";
    @Context
    private ServletContext servletContext;
    @Context
    private UriInfo uriInfo;
    @Context
    private Providers providers;
    private String callbackParam;

    @PostConstruct
    void init() {
        this.callbackParam = this.servletContext.getInitParameter(CALLBACK_PARAM_CONFIG);
        if (this.callbackParam == null) {
            this.callbackParam = CALLBACK_PARAM_DEFAULT;
        }
        LOG.debug("Using callbackParam '{}'", (Object)this.callbackParam);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter jsonWriter = this.providers.getMessageBodyWriter(type, genericType, annotations, MediaType.APPLICATION_JSON_TYPE);
        return jsonWriter.isWriteable(type, genericType, annotations, MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter jsonWriter = this.providers.getMessageBodyWriter(type, genericType, annotations, MediaType.APPLICATION_JSON_TYPE);
        String callback = (String)this.uriInfo.getQueryParameters().getFirst((Object)this.callbackParam);
        if (callback == null || callback.trim().isEmpty()) {
            throw new WebApplicationException("Missing JSONP callback", Response.Status.BAD_REQUEST);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jsonWriter.writeTo(o, type, genericType, annotations, mediaType, httpHeaders, (OutputStream)baos);
        entityStream.write((callback + "(").getBytes(StandardCharsets.UTF_8));
        baos.writeTo(entityStream);
        entityStream.write(");".getBytes(StandardCharsets.UTF_8));
    }
}

