/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.rhq.metrics.core.Counter;

public class DataAccess {
    private PreparedStatement insertData;
    private PreparedStatement findData;
    private PreparedStatement updateCounter;
    private PreparedStatement findCountersByGroup;
    private PreparedStatement findCountersByGroupAndName;
    private PreparedStatement listNames;
    private PreparedStatement removeMetricData;
    private Session session;

    public DataAccess(Session session) {
        this.session = session;
        this.initPreparedStatements();
    }

    private void initPreparedStatements() {
        this.insertData = this.session.prepare("INSERT INTO metrics (bucket, metric_id, time, value) VALUES (?, ?, ?, ?) USING TTL ?");
        this.findData = this.session.prepare("SELECT metric_id, time, value FROM metrics WHERE bucket = ? AND metric_id = ? AND time >=? AND time < ?");
        this.updateCounter = this.session.prepare("UPDATE counters SET c_value = c_value + ? WHERE group = ? AND c_name = ?");
        this.findCountersByGroup = this.session.prepare("SELECT group, c_name, c_value FROM counters WHERE group = ?");
        this.findCountersByGroupAndName = this.session.prepare("SELECT group, c_name, c_value FROM counters WHERE group = ? AND c_name IN ?");
        this.listNames = this.session.prepare("SELECT DISTINCT bucket, metric_id FROM metrics ");
        this.removeMetricData = this.session.prepare("DELETE FROM metrics WHERE bucket = 'raw' AND metric_id = ?");
    }

    public ResultSetFuture insertData(String bucket, String metricId, long timestamp, Map<Integer, Double> values, int ttl) {
        BoundStatement statement = this.insertData.bind(new Object[]{bucket, metricId, new Date(timestamp), values, ttl});
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture findData(String bucket, String metricId, long startTime, long endTime) {
        BoundStatement statement = this.findData.bind(new Object[]{bucket, metricId, new Date(startTime), new Date(endTime)});
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture updateCounter(Counter counter) {
        BoundStatement statement = this.updateCounter.bind(new Object[]{counter.getValue(), counter.getGroup(), counter.getName()});
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture updateCounters(Collection<Counter> counters) {
        BatchStatement batchStatement = new BatchStatement(BatchStatement.Type.COUNTER);
        for (Counter counter : counters) {
            batchStatement.add((Statement)this.updateCounter.bind(new Object[]{counter.getValue(), counter.getGroup(), counter.getName()}));
        }
        return this.session.executeAsync((Statement)batchStatement);
    }

    public ResultSetFuture findCounters(String group) {
        BoundStatement statement = this.findCountersByGroup.bind(new Object[]{group});
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture findCounters(String group, List<String> names) {
        BoundStatement statement = this.findCountersByGroupAndName.bind(new Object[]{group, names});
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture listMetricNames() {
        BoundStatement statement = this.listNames.bind();
        return this.session.executeAsync((Statement)statement);
    }

    public ResultSetFuture removeData(String id) {
        BoundStatement statement = this.removeMetricData.bind(new Object[]{id});
        return this.session.executeAsync((Statement)statement);
    }
}

