/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.UUID;
import org.rhq.metrics.core.AvailabilityMetric;
import org.rhq.metrics.core.AvailabilityType;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.Tag;

public class Availability
extends MetricData {
    private AvailabilityType type;

    public Availability(AvailabilityMetric metric, long timestamp, String availability) {
        this(metric, timestamp, AvailabilityType.fromString(availability));
    }

    public Availability(AvailabilityMetric metric, long timestamp, AvailabilityType type) {
        super((Metric)metric, timestamp);
        this.type = type;
    }

    public Availability(long timestamp, AvailabilityType type) {
        super(timestamp);
        this.type = type;
    }

    public Availability(AvailabilityMetric metric, UUID timeUUID, String availability) {
        super((Metric)metric, timeUUID);
        this.type = AvailabilityType.fromString(availability);
    }

    public Availability(AvailabilityMetric metric, UUID timeUUID, AvailabilityType type) {
        super((Metric)metric, timeUUID);
        this.type = type;
    }

    public Availability(AvailabilityMetric metric, UUID timeUUID, ByteBuffer bytes) {
        super((Metric)metric, timeUUID);
        this.type = AvailabilityType.fromBytes(bytes);
    }

    public Availability(AvailabilityMetric metric, UUID timeUUID, ByteBuffer bytes, Set<Tag> tags) {
        super(metric, timeUUID, tags);
        this.type = AvailabilityType.fromBytes(bytes);
    }

    public Availability(UUID timeUUID, ByteBuffer bytes, Set<Tag> tags) {
        super(timeUUID, tags);
        this.type = AvailabilityType.fromBytes(bytes);
    }

    public Availability(UUID timeUUID, ByteBuffer bytes, Set<Tag> tags, Long writeTime) {
        super(timeUUID, tags, writeTime);
        this.type = AvailabilityType.fromBytes(bytes);
    }

    public AvailabilityType getType() {
        return this.type;
    }

    public ByteBuffer getBytes() {
        return ByteBuffer.wrap(new byte[]{this.type.getCode()});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Availability)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Availability that = (Availability)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timeUUID", (Object)this.timeUUID).add("timestamp", this.getTimestamp()).add("type", (Object)this.type).toString();
    }
}

