/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.datastax.driver.core.utils.UUIDs;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.Tag;
import org.rhq.metrics.util.TimeUUIDUtils;

public abstract class MetricData {
    public static final Comparator<MetricData> TIME_UUID_COMPARATOR = new Comparator<MetricData>(){

        @Override
        public int compare(MetricData d1, MetricData d2) {
            return TimeUUIDUtils.compare(d1.timeUUID, d2.timeUUID);
        }
    };
    protected UUID timeUUID;
    protected Metric metric;
    protected Set<Tag> tags = new HashSet<Tag>();
    protected Long writeTime;
    protected Integer ttl;

    public MetricData(Metric metric, UUID timeUUID) {
        this.metric = metric;
        this.timeUUID = timeUUID;
    }

    public MetricData(Metric metric, UUID timeUUID, Set<Tag> tags) {
        this(metric, timeUUID, tags, null);
    }

    public MetricData(Metric metric, UUID timeUUID, Set<Tag> tags, Long writeTime) {
        this.metric = metric;
        this.timeUUID = timeUUID;
        this.tags = tags;
        this.writeTime = writeTime;
    }

    public MetricData(Metric metric, long timestamp) {
        this.metric = metric;
        this.timeUUID = TimeUUIDUtils.getTimeUUID(timestamp);
    }

    public MetricData(UUID timeUUID) {
        this.timeUUID = timeUUID;
    }

    public MetricData(UUID timeUUID, Set<Tag> tags) {
        this.timeUUID = timeUUID;
        this.tags = tags;
    }

    public MetricData(UUID timeUUID, Set<Tag> tags, Long writeTime) {
        this.timeUUID = timeUUID;
        this.tags = tags;
        this.writeTime = writeTime;
    }

    public MetricData(long timestamp) {
        this.timeUUID = TimeUUIDUtils.getTimeUUID(timestamp);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public UUID getTimeUUID() {
        return this.timeUUID;
    }

    public long getTimestamp() {
        return UUIDs.unixTimestamp((UUID)this.timeUUID);
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    public Long getWriteTime() {
        return this.writeTime;
    }

    public void setWriteTime(Long writeTime) {
        this.writeTime = writeTime;
    }

    public Integer getTTL() {
        return this.ttl;
    }

    public void setTTL(Integer ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricData)) {
            return false;
        }
        MetricData that = (MetricData)o;
        return this.timeUUID.equals(that.timeUUID);
    }

    public int hashCode() {
        return this.timeUUID.hashCode();
    }
}

