/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.rhq.metrics.core.AggregatedValue;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.NumericMetric2;
import org.rhq.metrics.core.Tag;
import org.rhq.metrics.util.TimeUUIDUtils;

public class NumericData
extends MetricData {
    private double value;
    private Set<AggregatedValue> aggregatedValues = new HashSet<AggregatedValue>();

    public NumericData(NumericMetric2 metric, long timestamp, double value) {
        this(metric, TimeUUIDUtils.getTimeUUID(timestamp), value);
    }

    public NumericData(NumericMetric2 metric, UUID timeUUID, double value) {
        super((Metric)metric, timeUUID);
        this.metric = metric;
        this.value = value;
    }

    public NumericData(NumericMetric2 metric, UUID timeUUID, double value, Set<Tag> tags) {
        super(metric, timeUUID, tags);
        this.value = value;
    }

    public NumericData(NumericMetric2 metric, UUID timeUUID, double value, Set<Tag> tags, Long writeTime) {
        super(metric, timeUUID, tags, writeTime);
    }

    public NumericData(long timestamp, double value) {
        super(timestamp);
        this.value = value;
    }

    public NumericData(UUID timeUUID, double value) {
        super(timeUUID);
        this.value = value;
    }

    public NumericData(UUID timeUUID, double value, Set<Tag> tags) {
        super(timeUUID, tags);
        this.value = value;
    }

    public NumericData(UUID timeUUID, double value, Set<Tag> tags, Long writeTime) {
        super(timeUUID, tags, writeTime);
        this.value = value;
    }

    @Override
    public Metric getMetric() {
        return this.metric;
    }

    public double getValue() {
        return this.value;
    }

    public NumericData setValue(double value) {
        this.value = value;
        return this;
    }

    public Set<AggregatedValue> getAggregatedValues() {
        return this.aggregatedValues;
    }

    public NumericData addAggregatedValue(AggregatedValue aggregatedValue) {
        this.aggregatedValues.add(aggregatedValue);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericData that = (NumericData)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timeUUID", (Object)this.timeUUID).add("timestamp", this.getTimestamp()).add("value", this.value).add("metric", (Object)this.metric).toString();
    }
}

