/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import java.util.Map;
import java.util.UUID;
import org.rhq.metrics.core.Availability;
import org.rhq.metrics.core.AvailabilityType;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;

public class AvailabilityMetric
extends Metric<Availability> {
    public AvailabilityMetric(String tenantId, MetricId id) {
        super(tenantId, id);
    }

    public AvailabilityMetric(String tenantId, MetricId id, Map<String, String> metadata) {
        super(tenantId, id, metadata);
    }

    public AvailabilityMetric(String tenantId, MetricId id, Map<String, String> metadata, Integer dataRetention) {
        super(tenantId, id, metadata, dataRetention);
    }

    @Override
    public MetricType getType() {
        return MetricType.AVAILABILITY;
    }

    public void addAvailability(long timestamp, AvailabilityType availability) {
        this.addData(new Availability(this, timestamp, availability));
    }

    public void addAvailability(long timestamp, String availability) {
        this.addData(new Availability(this, timestamp, AvailabilityType.fromString(availability)));
    }

    public void addAvailability(UUID timeUUID, AvailabilityType availability) {
        this.addData(new Availability(this, timeUUID, availability));
    }
}

