/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;

public abstract class Metric<T extends MetricData> {
    public static final long DPART = 0L;
    private String tenantId;
    private MetricId id;
    private Map<String, String> Metadata = new HashMap<String, String>();
    private long dpart = 0L;
    private List<T> data = new ArrayList<T>();
    private Integer dataRetention;

    protected Metric(String tenantId, MetricId id) {
        this.tenantId = tenantId;
        this.id = id;
    }

    protected Metric(String tenantId, MetricId id, Map<String, String> Metadata) {
        this.tenantId = tenantId;
        this.id = id;
        this.Metadata = Metadata;
    }

    protected Metric(String tenantId, MetricId id, Map<String, String> Metadata, Integer dataRetention) {
        this.tenantId = tenantId;
        this.id = id;
        this.Metadata = Metadata;
        this.dataRetention = dataRetention == null || dataRetention == 0 ? null : dataRetention;
    }

    public abstract MetricType getType();

    public String getTenantId() {
        return this.tenantId;
    }

    public Metric setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public MetricId getId() {
        return this.id;
    }

    public void setId(MetricId id) {
        this.id = id;
    }

    public long getDpart() {
        return this.dpart;
    }

    public void setDpart(long dpart) {
        this.dpart = dpart;
    }

    public Map<String, String> getMetadata() {
        return this.Metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.Metadata = metadata;
    }

    public void setAttribute(String name, String value) {
        this.Metadata.put(name, value);
    }

    public List<T> getData() {
        return this.data;
    }

    public void addData(T d) {
        this.data.add(d);
        ((MetricData)d).setMetric(this);
    }

    public Integer getDataRetention() {
        return this.dataRetention;
    }

    public void setDataRetention(Integer dataRetention) {
        this.dataRetention = dataRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        if (this.dpart != metric.dpart) {
            return false;
        }
        if (this.Metadata != null ? !this.Metadata.equals(metric.Metadata) : metric.Metadata != null) {
            return false;
        }
        if (this.dataRetention != null ? !this.dataRetention.equals(metric.dataRetention) : metric.dataRetention != null) {
            return false;
        }
        if (!this.id.equals(metric.id)) {
            return false;
        }
        return this.tenantId.equals(metric.tenantId);
    }

    public int hashCode() {
        int result = this.tenantId.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.Metadata != null ? this.Metadata.hashCode() : 0);
        result = 31 * result + (int)(this.dpart ^ this.dpart >>> 32);
        result = 31 * result + (this.dataRetention != null ? this.dataRetention.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("id", (Object)this.id).add("metadata", this.Metadata).add("dpart", this.dpart).add("dataRetention", (Object)this.dataRetention).toString();
    }
}

