/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.datastax.driver.core.utils.UUIDs;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.rhq.metrics.core.AggregatedValue;
import org.rhq.metrics.util.TimeUUIDUtils;

public class NumericDataPoint {
    private UUID timeUUID;
    private Double value;
    private Set<AggregatedValue> aggregatedValues = new HashSet<AggregatedValue>();

    public UUID getTimeUUID() {
        return this.timeUUID;
    }

    public void setTimeUUID(UUID timeUUID) {
        this.timeUUID = timeUUID;
    }

    public long getTimestamp() {
        return UUIDs.unixTimestamp((UUID)this.timeUUID);
    }

    public void setTimestamp(long timestamp) {
        this.timeUUID = TimeUUIDUtils.getTimeUUID(timestamp);
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Set<AggregatedValue> getAggregatedValues() {
        return this.aggregatedValues;
    }

    public void setAggregatedValues(Set<AggregatedValue> aggregatedValues) {
        this.aggregatedValues = aggregatedValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericDataPoint that = (NumericDataPoint)o;
        if (this.aggregatedValues != null ? !this.aggregatedValues.equals(that.aggregatedValues) : that.aggregatedValues != null) {
            return false;
        }
        if (!this.timeUUID.equals(that.timeUUID)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.timeUUID.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.aggregatedValues != null ? this.aggregatedValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timeUUID", (Object)this.timeUUID).add("timestamp", UUIDs.unixTimestamp((UUID)this.timeUUID)).add("value", (Object)this.value).toString();
    }
}

