/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.NumericData;
import org.rhq.metrics.core.Tag;

public class NumericMetric
extends Metric<NumericData> {
    public NumericMetric(String tenantId, MetricId id) {
        super(tenantId, id);
    }

    public NumericMetric(String tenantId, MetricId id, Map<String, String> metadata) {
        super(tenantId, id, metadata);
    }

    public NumericMetric(String tenantId, MetricId id, Map<String, String> metadata, Integer dataRetention) {
        super(tenantId, id, metadata, dataRetention);
    }

    @Override
    public MetricType getType() {
        return MetricType.NUMERIC;
    }

    public void addData(long timestamp, double value) {
        this.addData(new NumericData(this, timestamp, value));
    }

    public void addData(UUID timeUUID, double value) {
        this.addData(new NumericData(this, timeUUID, value));
    }

    public void addData(UUID timeUUID, double value, Set<Tag> tags) {
        this.addData(new NumericData(this, timeUUID, value, tags));
    }
}

