/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.util;

import com.datastax.driver.core.utils.UUIDs;
import com.eaio.uuid.UUIDGen;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;

public class TimeUUIDUtils {
    static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;

    public static UUID getTimeUUID(long time) {
        return new UUID(TimeUUIDUtils.createTime(time), UUIDGen.getClockSeqAndNode());
    }

    private static long createTime(long currentTime) {
        long timeToUse = currentTime * 10000L + 122192928000000000L;
        long time = timeToUse << 32;
        time |= (timeToUse & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeToUse >> 48 & 0xFFFL;
    }

    public static UUID getTimeUUID(Date d) {
        return TimeUUIDUtils.getTimeUUID(d.getTime());
    }

    public static UUID getTimeUUID(DateTime d) {
        return TimeUUIDUtils.getTimeUUID(d.getMillis());
    }

    public static int compare(UUID u1, UUID u2) {
        long ts2;
        long ts1 = UUIDs.unixTimestamp((UUID)u1);
        if (ts1 > (ts2 = UUIDs.unixTimestamp((UUID)u2))) {
            return 1;
        }
        if (ts1 < ts2) {
            return -1;
        }
        return u1.compareTo(u2);
    }
}

