/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;

public abstract class Metric<T extends MetricData> {
    public static final long DPART = 0L;
    private String tenantId;
    private MetricId id;
    private Map<String, Optional<String>> tags = new HashMap<String, Optional<String>>();
    private long dpart = 0L;
    private List<T> data = new ArrayList<T>();
    private Integer dataRetention;

    protected Metric(String tenantId, MetricId id) {
        this.tenantId = tenantId;
        this.id = id;
    }

    protected Metric(String tenantId, MetricId id, Map<String, Optional<String>> tags) {
        this.tenantId = tenantId;
        this.id = id;
        this.tags = tags;
    }

    protected Metric(String tenantId, MetricId id, Map<String, Optional<String>> tags, Integer dataRetention) {
        this.tenantId = tenantId;
        this.id = id;
        this.tags = tags;
        this.dataRetention = dataRetention == null || dataRetention == 0 ? null : dataRetention;
    }

    public abstract MetricType getType();

    public String getTenantId() {
        return this.tenantId;
    }

    public Metric setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public MetricId getId() {
        return this.id;
    }

    public void setId(MetricId id) {
        this.id = id;
    }

    public long getDpart() {
        return this.dpart;
    }

    public void setDpart(long dpart) {
        this.dpart = dpart;
    }

    public Map<String, Optional<String>> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Optional<String>> tags) {
        this.tags = tags;
    }

    public List<T> getData() {
        return this.data;
    }

    public void addData(T d) {
        this.data.add(d);
        ((MetricData)d).setMetric(this);
    }

    public Integer getDataRetention() {
        return this.dataRetention;
    }

    public void setDataRetention(Integer dataRetention) {
        this.dataRetention = dataRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        if (this.dpart != metric.dpart) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(metric.tags) : metric.tags != null) {
            return false;
        }
        if (this.dataRetention != null ? !this.dataRetention.equals(metric.dataRetention) : metric.dataRetention != null) {
            return false;
        }
        if (!this.id.equals(metric.id)) {
            return false;
        }
        return this.tenantId.equals(metric.tenantId);
    }

    public int hashCode() {
        int result = this.tenantId.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (int)(this.dpart ^ this.dpart >>> 32);
        result = 31 * result + (this.dataRetention != null ? this.dataRetention.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("id", (Object)this.id).add("tags", this.tags).add("dpart", this.dpart).add("dataRetention", (Object)this.dataRetention).toString();
    }
}

