/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.NumericData;

public class NumericMetric
extends Metric<NumericData> {
    public NumericMetric(String tenantId, MetricId id) {
        super(tenantId, id);
    }

    public NumericMetric(String tenantId, MetricId id, Map<String, Optional<String>> tags) {
        super(tenantId, id, tags);
    }

    public NumericMetric(String tenantId, MetricId id, Map<String, Optional<String>> tags, Integer dataRetention) {
        super(tenantId, id, tags, dataRetention);
    }

    @Override
    public MetricType getType() {
        return MetricType.NUMERIC;
    }

    public void addData(long timestamp, double value) {
        this.addData(new NumericData(this, timestamp, value));
    }

    public void addData(UUID timeUUID, double value) {
        this.addData(new NumericData(this, timeUUID, value));
    }

    public void addData(UUID timeUUID, double value, Map<String, Optional<String>> tags) {
        this.addData(new NumericData(this, timeUUID, value, tags));
    }
}

