/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.wflySender.service;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.metrics.scheduler.ModelControllerClientFactory;
import org.wildfly.metrics.scheduler.Service;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.config.ConfigurationInstance;
import org.wildfly.metrics.scheduler.config.Interval;
import org.wildfly.metrics.scheduler.config.ResourceRef;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class RhqMetricsService
implements org.jboss.msc.service.Service<RhqMetricsService> {
    private static final String SECONDS = "seconds";
    private static final String MINUTES = "minutes";
    private static final String HOURS = "hours";
    private boolean enabled;
    private ConfigurationInstance schedulerConfig;
    private Service schedulerService;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"rhq-metrics", "sender"});
    private boolean isStarted;

    public RhqMetricsService(ModelNode config, String remoteServer) {
        this.schedulerConfig = new ConfigurationInstance("localhost", 9990);
        int remotePort = config.get("port").asInt(8080);
        this.enabled = config.get("enabled").asBoolean(false);
        this.schedulerConfig.setRhqUrl("http://" + remoteServer + ":" + remotePort + "/rhq-metrics/metrics");
    }

    public static ServiceController<RhqMetricsService> addService(ServiceTarget target, ServiceVerificationHandler verificationHandler, String remoteServer, ModelNode config) {
        RhqMetricsService service = new RhqMetricsService(config, remoteServer);
        return target.addService(SERVICE_NAME, (org.jboss.msc.service.Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironmentValue).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public void start(StartContext startContext) throws StartException {
        if (this.enabled) {
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("RHQ-Metrics-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
            final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
            ModelControllerClient client = ((ModelController)this.modelControllerValue.getValue()).createClient((Executor)executorService);
            this.schedulerService = new Service((Configuration)this.schedulerConfig, new ModelControllerClientFactory(){

                public ModelControllerClient createClient() {
                    return ((ModelController)RhqMetricsService.this.modelControllerValue.getValue()).createClient((Executor)executorService);
                }
            });
            boolean isDomainMode = this.getStringAttribute(client, "launch-type", PathAddress.EMPTY_ADDRESS).equalsIgnoreCase("domain");
            String hostName = null;
            String serverName = null;
            ServerEnvironment serverEnv = (ServerEnvironment)this.serverEnvironmentValue.getValue();
            if (isDomainMode) {
                hostName = this.getStringAttribute(client, "local-host-name", PathAddress.EMPTY_ADDRESS);
                serverName = serverEnv.getServerName();
            } else {
                hostName = serverEnv.getQualifiedHostName();
                serverName = this.getStringAttribute(client, "name", PathAddress.EMPTY_ADDRESS);
            }
            this.schedulerService.start(hostName, serverName);
            this.schedulerService.reportEvery(30, TimeUnit.SECONDS);
        }
        this.isStarted = true;
    }

    public void stop(StopContext stopContext) {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
        this.isStarted = false;
    }

    public RhqMetricsService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private String getStringAttribute(ModelControllerClient client, String attributeName, PathAddress path) {
        try {
            ModelNode result = this.getModelNode(client, attributeName, path);
            return result.asString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private ModelNode getModelNode(ModelControllerClient client, String attributeName, PathAddress address) throws IOException {
        ModelNode request = new ModelNode();
        if (address != null) {
            request.get("address").set(address.toModelNode());
        }
        request.get("operation").set("read-attribute");
        request.get("name").set(attributeName);
        ModelNode resultNode = client.execute(request);
        resultNode = resultNode.get("result");
        return resultNode;
    }

    public void addMetric(String metricName, ModelNode metricResource) {
        if (this.isStarted) {
            throw new UnsupportedOperationException("Adding metric to running service is currently not supported");
        }
        Interval interval = null;
        if (metricResource.hasDefined(SECONDS)) {
            interval = new Interval(metricResource.get(SECONDS).asInt(), TimeUnit.SECONDS);
        } else if (metricResource.hasDefined(MINUTES)) {
            interval = new Interval(metricResource.get(MINUTES).asInt(), TimeUnit.MINUTES);
        } else if (metricResource.hasDefined(HOURS)) {
            interval = new Interval(metricResource.get(HOURS).asInt(), TimeUnit.HOURS);
        } else {
            System.out.println("Using default interval (20 seconds) for metric " + metricName);
            interval = Interval.TWENTY_SECONDS;
        }
        this.schedulerConfig.addResourceRef(new ResourceRef(metricResource.get("path").asString(), metricResource.get("attribute").asString(), interval));
    }

    public void removeMetric(String metricName) {
    }
}

