/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.modcluster.ModClusterServerComponent;
import org.rhq.plugins.modcluster.config.JBossWebServerFile;

public class CatalinaServiceComponent
extends MBeanResourceComponent<JMXComponent<?>> {
    private static final Log log = LogFactory.getLog(CatalinaServiceComponent.class);
    private static final String MOD_CLUSTER_CONFIG_FILE = "modclusterConfigFile";

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        super.updateResourceConfiguration(report);
        if (report.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
            try {
                super.invokeOperation("refresh", new Configuration());
            }
            catch (Exception e) {
                report.setErrorMessage("Failed to save the resource configuration to file. " + e.getMessage());
            }
            if (report.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
                this.saveResouceConfigurationToFile(report, true);
            }
        }
    }

    protected Object getPropertyValueAsType(PropertySimple propSimple, String typeName) {
        if (typeName.equals(TimeUnit.class.getName())) {
            return TimeUnit.valueOf(propSimple.getStringValue());
        }
        return super.getPropertyValueAsType(propSimple, typeName);
    }

    private void saveResouceConfigurationToFile(ConfigurationUpdateReport report, boolean ignoreReadOnly) {
        ConfigurationDefinition configurationDefinition = this.getResourceContext().getResourceType().getResourceConfigurationDefinition();
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            JBossWebServerFile jbossWebServerFile = this.getJBossWebServerFileInstance();
            for (String key : report.getConfiguration().getSimpleProperties().keySet()) {
                PropertySimple property = report.getConfiguration().getSimple(key);
                if (property == null) continue;
                try {
                    PropertyDefinitionSimple def = configurationDefinition.getPropertyDefinitionSimple(property.getName());
                    if (ignoreReadOnly && def.isReadOnly()) continue;
                    jbossWebServerFile.setPropertyValue(property.getName(), property.getStringValue());
                }
                catch (Exception e) {
                    property.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                    report.setErrorMessage("Failed setting resource configuration. " + e.getMessage());
                    log.info((Object)("Failure setting MBean Resource configuration value for " + key), (Throwable)e);
                }
            }
            jbossWebServerFile.saveConfigurationFile();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to save the resource configuration to file. " + e.getMessage());
            log.debug((Object)"Unable to save mod_cluster configuration file.", (Throwable)e);
        }
    }

    private JBossWebServerFile getJBossWebServerFileInstance() throws Exception {
        ModClusterServerComponent modClusterComponent = (ModClusterServerComponent)this.resourceContext.getParentResourceComponent();
        PropertySimple property = modClusterComponent.getResourceContext().getPluginConfiguration().getSimple(MOD_CLUSTER_CONFIG_FILE);
        if (property != null) {
            String fileName = property.getStringValue();
            return new JBossWebServerFile(fileName);
        }
        return null;
    }
}

