/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.rhq.plugins.modcluster.config.AbstractConfigurationFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModClusterBeanFile
extends AbstractConfigurationFile {
    private Node beanNode;

    public ModClusterBeanFile(String className, String configurationFileName) throws ParserConfigurationException, SAXException, IOException {
        this(className, new File(configurationFileName));
    }

    public ModClusterBeanFile(String className, File configurationFile) throws ParserConfigurationException, SAXException, IOException {
        super(configurationFile);
        this.beanNode = this.getBeanNodeByClass(className);
    }

    public ModClusterBeanFile(String className, String constructorArgumentClassName, String configurationFileName) throws ParserConfigurationException, SAXException, IOException {
        this(className, constructorArgumentClassName, new File(configurationFileName));
    }

    public ModClusterBeanFile(String className, String constructorArgumentClassName, File configurationFile) throws ParserConfigurationException, SAXException, IOException {
        super(configurationFile);
        Node primaryBeanNode = this.getBeanNodeByClass(className);
        String dependencyName = this.getBeanFromConstructorArgument(primaryBeanNode, constructorArgumentClassName);
        this.beanNode = this.getBeanNodeByName(dependencyName);
    }

    @Override
    public void setPropertyValue(String propertyName, String value) {
        boolean propertyFound = false;
        NodeList nodeList = this.beanNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (!currentNode.getNodeName().equals("property") || currentNode.getAttributes().getNamedItem("name") == null || !propertyName.equals(currentNode.getAttributes().getNamedItem("name").getTextContent())) continue;
            if (value != null) {
                currentNode.setTextContent(value);
            } else {
                this.beanNode.removeChild(currentNode);
            }
            propertyFound = true;
        }
        if (value != null && !propertyFound) {
            Element propertyChild = this.getDocument().createElement("property");
            Attr nameProperty = this.getDocument().createAttribute("name");
            nameProperty.setValue(propertyName);
            propertyChild.setTextContent(value);
            propertyChild.getAttributes().setNamedItem(nameProperty);
            this.beanNode.appendChild(propertyChild);
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        NodeList nodeList = this.beanNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (!currentNode.getNodeName().equals("property") || currentNode.getAttributes().getNamedItem("name") == null || !propertyName.equals(currentNode.getAttributes().getNamedItem("name").getTextContent())) continue;
            return currentNode.getTextContent();
        }
        return null;
    }

    private Node getBeanNodeByClass(String className) {
        NodeList nodeList = this.getDocument().getElementsByTagName("bean");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getAttributes().getNamedItem("class") == null || !className.equals(node.getAttributes().getNamedItem("class").getTextContent())) continue;
            return node;
        }
        return null;
    }

    private Node getBeanNodeByName(String beanName) {
        NodeList nodeList = this.getDocument().getElementsByTagName("bean");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getAttributes().getNamedItem("name") == null || !beanName.equals(node.getAttributes().getNamedItem("name").getTextContent())) continue;
            return node;
        }
        return null;
    }

    private String getBeanFromConstructorArgument(Node beanNode, String constructorArgumentClassName) {
        Node constructorNode;
        List<Node> nodeList = this.getChildrenNodesByName(beanNode, "constructor");
        if (nodeList.size() > 0 && (nodeList = this.getChildrenNodesByName(constructorNode = nodeList.get(0), "parameter")).size() > 0) {
            Node injectNode;
            Node beanAttribute;
            Node parameterNode = null;
            for (Node currentNode : nodeList) {
                if (currentNode.getAttributes().getNamedItem("class") == null || !constructorArgumentClassName.equals(currentNode.getAttributes().getNamedItem("class").getTextContent())) continue;
                parameterNode = currentNode;
                break;
            }
            if (parameterNode != null && (nodeList = this.getChildrenNodesByName(parameterNode, "inject")).size() > 0 && (beanAttribute = (injectNode = nodeList.get(0)).getAttributes().getNamedItem("bean")) != null) {
                return beanAttribute.getTextContent();
            }
        }
        return null;
    }

    private List<Node> getChildrenNodesByName(Node node, String nodeName) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node currentNode = node.getChildNodes().item(i);
            if (!nodeName.equals(currentNode.getNodeName())) continue;
            nodeList.add(currentNode);
        }
        return nodeList;
    }
}

