/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProxyInfo {
    private Map<String, Node> availableNodes = new HashMap<String, Node>();
    private Map<String, Vhost> availableVhosts = new HashMap<String, Vhost>();
    private List<Context> availableContexts = new ArrayList<Context>();

    public ProxyInfo(String rawProxyInfo) {
        this.parseNodes(rawProxyInfo);
        this.parseVhosts(rawProxyInfo);
        this.parseContexts(rawProxyInfo);
    }

    private void parseNodes(String rawProxyInfo) {
        Pattern nodePattern = Pattern.compile("Node:.*\n");
        Matcher nodeMatcher = nodePattern.matcher(rawProxyInfo);
        while (nodeMatcher.find()) {
            String rawNode = nodeMatcher.group();
            String[] nodePieces = rawNode.split(",");
            String identifier = nodePieces[0];
            identifier = identifier.substring(identifier.indexOf("[") + 1, identifier.indexOf("]"));
            String jvmRoute = nodePieces[1];
            jvmRoute = jvmRoute.substring(jvmRoute.indexOf(58) + 1).trim();
            this.availableNodes.put(identifier, new Node(jvmRoute, identifier));
        }
    }

    private void parseVhosts(String rawProxyInfo) {
        Pattern vhostPattern = Pattern.compile("Vhost:.*\n");
        Matcher vhostMatcher = vhostPattern.matcher(rawProxyInfo);
        while (vhostMatcher.find()) {
            String rawVhost = vhostMatcher.group();
            String[] vhostPieces = rawVhost.split(",");
            String identifier = vhostPieces[0].trim();
            identifier = identifier.substring(identifier.indexOf("[") + 1, identifier.indexOf("]"));
            identifier = identifier.substring(0, identifier.lastIndexOf(":"));
            String host = vhostPieces[1].trim();
            host = host.substring(host.indexOf(":") + 1).trim();
            this.availableVhosts.put(identifier, new Vhost(identifier, host));
        }
    }

    private void parseContexts(String rawProxyInfo) {
        Pattern contextPattern = Pattern.compile("Context:.*[\n|}]");
        Matcher contextMatcher = contextPattern.matcher(rawProxyInfo);
        while (contextMatcher.find()) {
            String rawContext = contextMatcher.group();
            String[] contextPieces = rawContext.split(",");
            String actualContext = contextPieces[1].substring(contextPieces[1].indexOf("/")).trim();
            String identifier = contextPieces[0];
            identifier = identifier.substring(identifier.indexOf("[") + 1, identifier.indexOf("]"));
            identifier = identifier.substring(0, identifier.lastIndexOf(":"));
            String nodeIdentifier = contextPieces[0];
            nodeIdentifier = nodeIdentifier.substring(nodeIdentifier.indexOf("[") + 1, nodeIdentifier.indexOf("]"));
            nodeIdentifier = nodeIdentifier.substring(0, nodeIdentifier.indexOf(":"));
            String jvmRoute = this.availableNodes.get(nodeIdentifier).getJvmRoute();
            String rawIsEnabled = contextPieces[2];
            boolean isEnabled = (rawIsEnabled = rawIsEnabled.substring(rawIsEnabled.indexOf(58) + 1).trim()).equals("ENABLED");
            Vhost relatedVhost = this.availableVhosts.get(identifier);
            this.availableContexts.add(new Context(jvmRoute, relatedVhost.getHost(), actualContext, isEnabled));
        }
    }

    public List<Context> getAvailableContexts() {
        return Collections.unmodifiableList(this.availableContexts);
    }

    public List<Vhost> getAvailableVhosts() {
        return Collections.unmodifiableList(new ArrayList<Vhost>(this.availableVhosts.values()));
    }

    public List<Node> getAvailableNodes() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.availableNodes.values()));
    }

    public static class Context {
        private String path;
        private String host;
        private String jvmRoute;
        private boolean isEnabled;

        public Context(String jvmRoute, String host, String path) {
            this(jvmRoute, host, path, false);
        }

        public Context(String jvmRoute, String host, String path, boolean isEnabled) {
            this.jvmRoute = jvmRoute;
            this.host = host;
            this.path = path;
            this.isEnabled = isEnabled;
        }

        public String getPath() {
            return this.path;
        }

        public String getHost() {
            return this.host;
        }

        public String getJvmRoute() {
            return this.jvmRoute;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public String createKey() {
            return this.jvmRoute + ":" + this.host + ":" + this.path;
        }

        public String createName() {
            return this.host + ":" + this.path;
        }

        public String toString() {
            return this.createKey();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + (this.jvmRoute == null ? 0 : this.jvmRoute.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.jvmRoute == null ? other.jvmRoute != null : !this.jvmRoute.equals(other.jvmRoute)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public static Context fromString(String stringRepresentation) throws Exception {
            String[] parts = stringRepresentation.trim().split(":");
            if (parts.length < 3) {
                throw new Exception("Parsing error. Not enough information to create a context.");
            }
            return new Context(parts[0], parts[1], parts[2]);
        }
    }

    public static class Vhost {
        private String identifier;
        private String host;

        public Vhost(String identifier, String host) {
            this.identifier = identifier;
            this.host = host;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getHost() {
            return this.host;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Vhost other = (Vhost)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
        }
    }

    public static class Node {
        private String jvmRoute;
        private String nodeId;

        public Node(String jvmRoute, String nodeId) {
            this.jvmRoute = jvmRoute;
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getJvmRoute() {
            return this.jvmRoute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jvmRoute == null ? 0 : this.jvmRoute.hashCode());
            result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.jvmRoute == null ? other.jvmRoute != null : !this.jvmRoute.equals(other.jvmRoute)) {
                return false;
            }
            return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
        }
    }
}

