/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.enterprise.agent.AgentManagement;
import org.rhq.enterprise.agent.AgentManagementMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog(AgentDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.info((Object)"Discovering RHQ Agent...");
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        try {
            String name;
            AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
            String agentName = mbean.getAgentConfiguration().getProperty("rhq.agent.name");
            String key = name = agentName + " RHQ Agent";
            String version = mbean.getVersion();
            String description = "RHQ Management Agent";
            DiscoveredResourceDetails localVM = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, null, null);
            Configuration configuration = localVM.getPluginConfiguration();
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)"Local Connection"));
            configuration.put((Property)new PropertySimple("type", (Object)InternalVMTypeDescriptor.class.getName()));
            set.add(localVM);
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while attempting to auto-discover the agent's own management interface", (Throwable)e);
        }
        return set;
    }

    static MBeanServer getAgentManagementMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the agent's management MBeanServer", e);
        }
    }

    static AgentManagementMBean getAgentManagementMBean() {
        try {
            AgentManagementMBean mbean = MBeanServerInvocationHandler.newProxyInstance(AgentDiscoveryComponent.getAgentManagementMBeanServer(), AgentManagement.singletonObjectName, AgentManagementMBean.class, false);
            return mbean;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the agent's management MBean", e);
        }
    }
}

