/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;
import org.rhq.enterprise.agent.EnvironmentScriptFileUpdate;
import org.rhq.plugins.agent.AgentServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentEnvironmentScriptComponent
implements ResourceComponent<AgentServerComponent>,
ConfigurationFacet {
    private Log log = LogFactory.getLog(AgentEnvironmentScriptComponent.class);
    private File script;

    public void start(ResourceContext<AgentServerComponent> resourceContext) throws Exception {
        Configuration pc = resourceContext.getPluginConfiguration();
        PropertySimple pathnameProp = pc.getSimple("Pathname");
        if (pathnameProp == null) {
            throw new InvalidPluginConfigurationException("Pathname property is missing");
        }
        if (pathnameProp.getStringValue() == null) {
            throw new InvalidPluginConfigurationException("Pathname property value is null");
        }
        this.script = new File(pathnameProp.getStringValue());
        if (!this.script.exists()) {
            throw new InvalidPluginConfigurationException("Script [" + this.script + "] does not exist");
        }
        this.log.debug((Object)("Starting agent env script component: " + this.script));
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.script.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.script.getAbsolutePath());
        List variables = updater.loadExisting();
        Configuration config = new Configuration();
        PropertyList list = new PropertyList("environmentVariables");
        config.put((Property)list);
        for (EnvironmentScriptFileUpdate.NameValuePair var : variables) {
            PropertyMap map = new PropertyMap("environmentVariable");
            map.put((Property)new PropertySimple("name", (Object)var.name));
            map.put((Property)new PropertySimple("value", (Object)var.value));
            list.add((Property)map);
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport request) {
        try {
            ArrayList<EnvironmentScriptFileUpdate.NameValuePair> newSettings = new ArrayList<EnvironmentScriptFileUpdate.NameValuePair>();
            Configuration configuration = request.getConfiguration();
            PropertyList list = configuration.getList("environmentVariables");
            if (list == null || list.getList() == null) {
                throw new Exception("Missing env vars config");
            }
            for (Property item : list.getList()) {
                PropertyMap map = (PropertyMap)item;
                PropertySimple name = map.getSimple("name");
                PropertySimple value = map.getSimple("value");
                if (name == null || name.getStringValue() == null) {
                    this.log.error((Object)("Missing an env var name: " + configuration.toString(true)));
                    throw new IllegalArgumentException("Missing the name of an environment variable");
                }
                if (value == null || value.getStringValue() == null) continue;
                newSettings.add(new EnvironmentScriptFileUpdate.NameValuePair(name.getStringValue(), value.getStringValue()));
            }
            EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.script.getAbsolutePath());
            updater.update(newSettings, true);
            request.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }
}

