/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.agent.AgentServerComponent;

public class AgentLauncherScriptComponent
implements ResourceComponent<AgentServerComponent>,
OperationFacet {
    private Log log = LogFactory.getLog(AgentLauncherScriptComponent.class);
    private ResourceContext<AgentServerComponent> resourceContext;
    private File launcherScript;

    public void start(ResourceContext<AgentServerComponent> rc) throws Exception {
        this.resourceContext = rc;
        Configuration pc = this.resourceContext.getPluginConfiguration();
        PropertySimple prop = pc.getSimple("Pathname");
        if (prop == null) {
            throw new InvalidPluginConfigurationException("Missing path to launcher script");
        }
        if (prop.getStringValue() == null) {
            throw new InvalidPluginConfigurationException("Launcher script pathname property value is null");
        }
        this.launcherScript = new File(prop.getStringValue());
        if (!this.launcherScript.exists()) {
            throw new InvalidPluginConfigurationException("Launcher Script [" + this.launcherScript + "] does not exist");
        }
        this.log.debug((Object)("Starting agent launcher script component: " + this.launcherScript));
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.launcherScript.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult result;
        block6: {
            this.log.info((Object)("Launcher script executing [" + name + "]"));
            result = null;
            try {
                if (name.equals("Status")) {
                    Map<Integer, String> output = this.executeLauncherScript("status");
                    result = new OperationResult();
                    Integer exitCode = output.keySet().iterator().next();
                    result.getComplexResults().put((Property)new PropertySimple("exitCode", (Object)exitCode));
                    result.getComplexResults().put((Property)new PropertySimple("output", output.values().toArray()[0]));
                    break block6;
                }
                if (name.equals("Restart")) {
                    this.executeLauncherScriptInThread("quiet-restart");
                    break block6;
                }
                if (name.equals("Stop")) {
                    this.executeLauncherScriptInThread("stop");
                    break block6;
                }
                if (name.equals("Kill")) {
                    this.executeLauncherScriptInThread("kill");
                    break block6;
                }
                throw new UnsupportedOperationException("Invalid operation name: " + name);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke operation [" + name + "]", e);
            }
        }
        this.log.info((Object)("Launcher script executed [" + name + "]: " + result));
        return result;
    }

    private Map<Integer, String> executeLauncherScript(String arg) throws Exception {
        if (!this.launcherScript.exists()) {
            throw new Exception("Launcher script [" + this.launcherScript + "] does not exist");
        }
        HashMap<String, String> envvars = new HashMap<String, String>(System.getenv());
        envvars.put("RHQ_AGENT_DEBUG", "false");
        ProcessExecution exe = new ProcessExecution(this.launcherScript.getAbsolutePath());
        exe.setArguments(new String[]{arg});
        exe.setWorkingDirectory(this.launcherScript.getParent());
        exe.setCaptureOutput(true);
        exe.setWaitForCompletion(30000L);
        exe.setEnvironmentVariables(envvars);
        ProcessExecutionResults results = this.resourceContext.getSystemInformation().executeProcess(exe);
        Throwable error = results.getError();
        if (error != null) {
            throw new Exception("Failed to invoke [" + this.launcherScript + ' ' + arg + "]", error);
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Integer exitCode = results.getExitCode();
        String output = results.getCapturedOutput();
        map.put(exitCode != null ? exitCode : Integer.valueOf(-1), output != null ? output : "");
        return map;
    }

    private void executeLauncherScriptInThread(final String arg) throws Exception {
        if (!this.launcherScript.exists()) {
            throw new Exception("Launcher script [" + this.launcherScript + "] does not exist");
        }
        final File script = this.launcherScript;
        final SystemInfo sysInfo = this.resourceContext.getSystemInformation();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    ProcessExecution exe = new ProcessExecution(script.getAbsolutePath());
                    exe.setArguments(new String[]{arg});
                    exe.setWorkingDirectory(script.getParent());
                    ProcessExecutionResults results = sysInfo.executeProcess(exe);
                    if (results != null && results.getError() != null) {
                        throw results.getError();
                    }
                }
                catch (Throwable t) {
                    AgentLauncherScriptComponent.this.log.error((Object)("Failed to invoke [" + script + ' ' + arg + "] in a thread"), t);
                }
            }
        }, "RHQ Agent Plugin Launcher Script Thread");
        thread.setDaemon(true);
        thread.start();
    }
}

