/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.enterprise.agent.AgentManagement;
import org.rhq.enterprise.agent.AgentManagementMBean;

public class AgentDiscoveryComponent
implements ResourceDiscoveryComponent,
ResourceUpgradeFacet {
    private static final String RESOURCE_NAME = "RHQ Agent";
    private final Log log = LogFactory.getLog(AgentDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.info((Object)"Discovering RHQ Agent...");
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        try {
            AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
            String name = RESOURCE_NAME;
            String key = AgentDiscoveryComponent.getResourceKey(mbean);
            String version = mbean.getVersion();
            String description = "RHQ Management Agent";
            DiscoveredResourceDetails localVM = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, null, null);
            Configuration pluginConfiguration = localVM.getPluginConfiguration();
            pluginConfiguration.put((Property)new PropertySimple("connectorAddress", (Object)"Local Connection"));
            pluginConfiguration.put((Property)new PropertySimple("type", (Object)InternalVMTypeDescriptor.class.getName()));
            this.initLogEventSourcesConfigProp(mbean, pluginConfiguration);
            set.add(localVM);
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while attempting to auto-discover the agent's own management interface", (Throwable)e);
        }
        return set;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext inventoriedResource) {
        AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
        String oldResourceKey = inventoriedResource.getResourceKey();
        String newResourceKey = AgentDiscoveryComponent.getResourceKey(mbean);
        ResourceUpgradeReport ret = null;
        if (!oldResourceKey.equals(newResourceKey)) {
            ret = new ResourceUpgradeReport();
            ret.setNewResourceKey(newResourceKey);
            return ret;
        }
        return ret;
    }

    private static String getResourceKey(AgentManagementMBean mbean) {
        String agentName = mbean.getAgentConfiguration().getProperty("rhq.agent.name");
        return agentName + " RHQ Agent";
    }

    private void initLogEventSourcesConfigProp(AgentManagementMBean agent, Configuration pluginConfiguration) {
        File commandTraceLogFile;
        File agentLogFile;
        File logsDir = new File(agent.getAgentHomeDirectory(), "logs");
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            logEventSources = new PropertyList("logEventSources");
            pluginConfiguration.put((Property)logEventSources);
        }
        if ((agentLogFile = new File(logsDir, "agent.log")).exists() && !agentLogFile.isDirectory()) {
            PropertyMap agentLogEventSource = new PropertyMap("logEventSource");
            agentLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)agentLogFile));
            agentLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            agentLogEventSource.put((Property)new PropertySimple("minimumSeverity", (Object)EventSeverity.ERROR.name()));
            logEventSources.add((Property)agentLogEventSource);
        }
        if ((commandTraceLogFile = new File(logsDir, "command-trace.log")).exists() && !commandTraceLogFile.isDirectory()) {
            PropertyMap commandTraceLogEventSource = new PropertyMap("logEventSource");
            commandTraceLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)commandTraceLogFile));
            commandTraceLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)commandTraceLogEventSource);
        }
    }

    static MBeanServer getAgentManagementMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the agent's management MBeanServer", e);
        }
    }

    static AgentManagementMBean getAgentManagementMBean() {
        try {
            AgentManagementMBean mbean = MBeanServerInvocationHandler.newProxyInstance(AgentDiscoveryComponent.getAgentManagementMBeanServer(), AgentManagement.singletonObjectName, AgentManagementMBean.class, false);
            return mbean;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the agent's management MBean", e);
        }
    }
}

