/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;
import org.rhq.enterprise.agent.EnvironmentScriptFileUpdate;
import org.rhq.plugins.agent.AgentServerComponent;

public class AgentJavaServiceWrapperComponent
implements ResourceComponent<AgentServerComponent<?>>,
ConfigurationFacet,
OperationFacet {
    private Log log = LogFactory.getLog(AgentJavaServiceWrapperComponent.class);
    private ResourceContext<AgentServerComponent<?>> resourceContext;
    private File launcherScript;
    private File configFile;
    private File environmentFile;
    private File includeFile;

    public void start(ResourceContext<AgentServerComponent<?>> rc) throws Exception {
        this.resourceContext = rc;
        Configuration pc = this.resourceContext.getPluginConfiguration();
        PropertySimple prop = pc.getSimple("launcherScript");
        if (prop == null) {
            throw new InvalidPluginConfigurationException("Missing Launcher Script");
        }
        if (prop.getStringValue() == null) {
            throw new InvalidPluginConfigurationException("Launcher Script property value is null");
        }
        this.launcherScript = new File(prop.getStringValue());
        if (!this.launcherScript.exists()) {
            throw new InvalidPluginConfigurationException("Launcher Script [" + this.launcherScript + "] does not exist");
        }
        prop = pc.getSimple("configurationFile");
        if (prop == null) {
            throw new InvalidPluginConfigurationException("Missing Configuration File");
        }
        if (prop.getStringValue() == null) {
            throw new InvalidPluginConfigurationException("Configuration File property value is null");
        }
        this.configFile = new File(prop.getStringValue());
        if (!this.configFile.exists()) {
            throw new InvalidPluginConfigurationException("Config file [" + this.configFile + "] does not exist");
        }
        this.log.debug((Object)("Starting agent JSW component: " + this.configFile));
        prop = pc.getSimple("environmentFile");
        if (prop != null && prop.getStringValue() != null) {
            this.environmentFile = new File(prop.getStringValue());
        }
        if ((prop = pc.getSimple("includeFile")) != null && prop.getStringValue() != null) {
            this.includeFile = new File(prop.getStringValue());
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.launcherScript.exists() && this.configFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult result;
        block7: {
            this.log.info((Object)("Wrapper launcher script executing [" + name + "]"));
            result = null;
            try {
                if (name.equals("Status")) {
                    Map<Integer, String> output = this.executeLauncherScript("status");
                    result = new OperationResult();
                    Integer exitCode = output.keySet().iterator().next();
                    this.determineServiceStatus(exitCode, result);
                    result.getComplexResults().put((Property)new PropertySimple("exitCode", (Object)exitCode));
                    result.getComplexResults().put((Property)new PropertySimple("output", output.values().toArray()[0]));
                    break block7;
                }
                if (name.equals("Install")) {
                    Map<Integer, String> output = this.executeLauncherScript("install");
                    result = new OperationResult();
                    Integer exitCode = output.keySet().iterator().next();
                    result.getComplexResults().put((Property)new PropertySimple("exitCode", (Object)exitCode));
                    result.getComplexResults().put((Property)new PropertySimple("output", output.values().toArray()[0]));
                    break block7;
                }
                if (name.equals("Restart")) {
                    this.executeLauncherScriptInThread("restart");
                    break block7;
                }
                if (name.equals("Stop")) {
                    this.executeLauncherScriptInThread("stop");
                    break block7;
                }
                if (name.equals("Remove")) {
                    this.executeLauncherScriptInThread("remove");
                    break block7;
                }
                throw new UnsupportedOperationException("Invalid operation name: " + name);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke operation [" + name + "]", e);
            }
        }
        this.log.info((Object)("Launcher script executed [" + name + "]: " + result));
        return result;
    }

    private void determineServiceStatus(Integer exitCode, OperationResult result) {
        if (exitCode == null || exitCode < 0) {
            return;
        }
        int bitmask = exitCode;
        Configuration map = result.getComplexResults();
        map.put((Property)new PropertySimple("disabled", (Object)((bitmask & 0x20) == 32 ? Boolean.TRUE : Boolean.FALSE)));
        map.put((Property)new PropertySimple("requiresManualStart", (Object)((bitmask & 0x10) == 16 ? Boolean.TRUE : Boolean.FALSE)));
        map.put((Property)new PropertySimple("willAutomaticallyStart", (Object)((bitmask & 8) == 8 ? Boolean.TRUE : Boolean.FALSE)));
        map.put((Property)new PropertySimple("hasInteractiveConsole", (Object)((bitmask & 4) == 4 ? Boolean.TRUE : Boolean.FALSE)));
        map.put((Property)new PropertySimple("isRunning", (Object)((bitmask & 2) == 2 ? Boolean.TRUE : Boolean.FALSE)));
        map.put((Property)new PropertySimple("isInstalled", (Object)((bitmask & 1) == 1 ? Boolean.TRUE : Boolean.FALSE)));
    }

    private Map<Integer, String> executeLauncherScript(String arg) throws Exception {
        if (!this.launcherScript.exists()) {
            throw new Exception("Launcher script [" + this.launcherScript + "] does not exist");
        }
        HashMap<String, String> envvars = new HashMap<String, String>(System.getenv());
        envvars.put("RHQ_AGENT_DEBUG", "false");
        ProcessExecution exe = new ProcessExecution(this.launcherScript.getAbsolutePath());
        exe.setArguments(new String[]{arg});
        exe.setWorkingDirectory(this.launcherScript.getParent());
        exe.setCaptureOutput(true);
        exe.setWaitForCompletion(30000L);
        exe.setEnvironmentVariables(envvars);
        ProcessExecutionResults results = this.resourceContext.getSystemInformation().executeProcess(exe);
        Throwable error = results.getError();
        if (error != null) {
            throw new Exception("Failed to invoke [" + this.launcherScript + ' ' + arg + "]", error);
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Integer exitCode = results.getExitCode();
        String output = results.getCapturedOutput();
        map.put(exitCode != null ? exitCode : Integer.valueOf(-1), output != null ? output : "");
        return map;
    }

    private void executeLauncherScriptInThread(final String arg) throws Exception {
        if (!this.launcherScript.exists()) {
            throw new Exception("Launcher script [" + this.launcherScript + "] does not exist");
        }
        final File script = this.launcherScript;
        final SystemInfo sysInfo = this.resourceContext.getSystemInformation();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    ProcessExecution exe = new ProcessExecution(script.getAbsolutePath());
                    exe.setArguments(new String[]{arg});
                    exe.setWorkingDirectory(script.getParent());
                    ProcessExecutionResults results = sysInfo.executeProcess(exe);
                    if (results != null && results.getError() != null) {
                        throw results.getError();
                    }
                }
                catch (Throwable t) {
                    AgentJavaServiceWrapperComponent.this.log.error((Object)("Failed to invoke [" + script + ' ' + arg + "] in a thread"), t);
                }
            }
        }, "RHQ Agent Plugin JSW Launcher Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        PropertyList conf = this.loadConfigurationFileConfiguration();
        PropertyList env = this.loadEnvironmentFileConfiguration();
        PropertyList inc = this.loadIncludeFileConfiguration();
        if (conf != null) {
            config.put((Property)conf);
        }
        if (env != null) {
            config.put((Property)env);
        }
        if (inc != null) {
            config.put((Property)inc);
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport request) {
        try {
            this.updateConfigurationFileConfiguration(request);
            this.updateEnvironmentFileConfiguration(request);
            this.updateIncludeFileConfiguration(request);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }

    private PropertyList loadConfigurationFileConfiguration() throws Exception {
        if (this.configFile == null || !this.configFile.exists()) {
            return null;
        }
        EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.configFile.getAbsolutePath());
        List properties = updater.loadExisting();
        PropertyList list = new PropertyList("mainConfigurationSettings");
        for (EnvironmentScriptFileUpdate.NameValuePair prop : properties) {
            PropertyMap map = new PropertyMap("mainConfigurationSetting");
            map.put((Property)new PropertySimple("name", (Object)prop.name));
            map.put((Property)new PropertySimple("value", (Object)prop.value));
            list.add((Property)map);
        }
        return list;
    }

    private PropertyList loadEnvironmentFileConfiguration() throws Exception {
        if (this.environmentFile == null || !this.environmentFile.exists()) {
            return null;
        }
        EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.environmentFile.getAbsolutePath());
        List properties = updater.loadExisting();
        PropertyList list = new PropertyList("environmentSettings");
        for (EnvironmentScriptFileUpdate.NameValuePair prop : properties) {
            PropertyMap map = new PropertyMap("environmentSetting");
            map.put((Property)new PropertySimple("name", (Object)prop.name));
            map.put((Property)new PropertySimple("value", (Object)prop.value));
            list.add((Property)map);
        }
        return list;
    }

    private PropertyList loadIncludeFileConfiguration() throws Exception {
        if (this.includeFile == null || !this.includeFile.exists()) {
            return null;
        }
        EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.includeFile.getAbsolutePath());
        List properties = updater.loadExisting();
        PropertyList list = new PropertyList("includeSettings");
        for (EnvironmentScriptFileUpdate.NameValuePair prop : properties) {
            PropertyMap map = new PropertyMap("includeSetting");
            map.put((Property)new PropertySimple("name", (Object)prop.name));
            map.put((Property)new PropertySimple("value", (Object)prop.value));
            list.add((Property)map);
        }
        return list;
    }

    private void updateConfigurationFileConfiguration(ConfigurationUpdateReport request) {
        try {
            ArrayList<EnvironmentScriptFileUpdate.NameValuePair> newSettings = new ArrayList<EnvironmentScriptFileUpdate.NameValuePair>();
            Configuration configuration = request.getConfiguration();
            PropertyList list = configuration.getList("mainConfigurationSettings");
            if (list == null) {
                throw new Exception("Missing main config");
            }
            for (Property item : list.getList()) {
                PropertyMap map = (PropertyMap)item;
                PropertySimple name = map.getSimple("name");
                PropertySimple value = map.getSimple("value");
                if (name == null || name.getStringValue() == null) {
                    this.log.error((Object)("Missing a config name: " + configuration.toString(true)));
                    throw new IllegalArgumentException("Missing the name of a main config setting");
                }
                if (value == null || value.getStringValue() == null) continue;
                newSettings.add(new EnvironmentScriptFileUpdate.NameValuePair(name.getStringValue(), value.getStringValue()));
            }
            EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.configFile.getAbsolutePath());
            updater.update(newSettings, true);
            request.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }

    private void updateEnvironmentFileConfiguration(ConfigurationUpdateReport request) {
        try {
            ArrayList<EnvironmentScriptFileUpdate.NameValuePair> newSettings = new ArrayList<EnvironmentScriptFileUpdate.NameValuePair>();
            Configuration configuration = request.getConfiguration();
            PropertyList list = configuration.getList("environmentSettings");
            if (list == null || list.getList() == null || list.getList().isEmpty()) {
                if (this.environmentFile.exists() && !this.environmentFile.delete()) {
                    throw new Exception("Failed to remove the env file: " + this.environmentFile);
                }
                return;
            }
            for (Property item : list.getList()) {
                PropertyMap map = (PropertyMap)item;
                PropertySimple name = map.getSimple("name");
                PropertySimple value = map.getSimple("value");
                if (name == null || name.getStringValue() == null) {
                    this.log.error((Object)("Missing a env name: " + configuration.toString(true)));
                    throw new IllegalArgumentException("Missing the name of a env setting");
                }
                if (value == null || value.getStringValue() == null) continue;
                newSettings.add(new EnvironmentScriptFileUpdate.NameValuePair(name.getStringValue(), value.getStringValue()));
            }
            EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.environmentFile.getAbsolutePath());
            updater.update(newSettings, true);
            request.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }

    private void updateIncludeFileConfiguration(ConfigurationUpdateReport request) {
        try {
            ArrayList<EnvironmentScriptFileUpdate.NameValuePair> newSettings = new ArrayList<EnvironmentScriptFileUpdate.NameValuePair>();
            Configuration configuration = request.getConfiguration();
            PropertyList list = configuration.getList("includeSettings");
            if (list == null || list.getList() == null || list.getList().isEmpty()) {
                if (this.includeFile.exists() && !this.includeFile.delete()) {
                    throw new Exception("Failed to remove the include file: " + this.includeFile);
                }
                return;
            }
            for (Property item : list.getList()) {
                PropertyMap map = (PropertyMap)item;
                PropertySimple name = map.getSimple("name");
                PropertySimple value = map.getSimple("value");
                if (name == null || name.getStringValue() == null) {
                    this.log.error((Object)("Missing a inc name: " + configuration.toString(true)));
                    throw new IllegalArgumentException("Missing the name of a include setting");
                }
                if (value == null || value.getStringValue() == null) continue;
                newSettings.add(new EnvironmentScriptFileUpdate.NameValuePair(name.getStringValue(), value.getStringValue()));
            }
            EnvironmentScriptFileUpdate updater = EnvironmentScriptFileUpdate.create((String)this.includeFile.getAbsolutePath());
            updater.update(newSettings, true);
            request.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }
}

